/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.ads.utils.CallbackUtil;
import com.google.ads.utils.LogUtil;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;

public class AppOpenAds
extends UniModule {
    private UniJSCallback mShowCallback;
    private String mAdUnitId;
    private boolean isLoadingAd = false;
    private AppOpenAd appOpenAd = null;
    private boolean isShowingAd = false;

    @UniJSMethod(uiThread=true)
    public void loadAppOpenAd(String adUnitId, final UniJSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            CallbackUtil.handleCallback(callback, 1002, "adUnitId cannot be empty");
            return;
        }
        Context context = this.mUniSDKInstance.getContext();
        this.mAdUnitId = adUnitId;
        if (this.appOpenAd != null) {
            String completeMsg = "AppOpenAd for " + this.mAdUnitId + " already loaded";
            LogUtil.e(completeMsg);
            CallbackUtil.handleCallback(callback, 201, completeMsg);
            return;
        }
        if (this.isLoadingAd) {
            String completeMsg = "AppOpenAd for " + this.mAdUnitId + "failed to load: Ads are loading, please do not repeat the load";
            LogUtil.e(completeMsg);
            CallbackUtil.handleCallback(callback, 1003, completeMsg);
            return;
        }
        this.isLoadingAd = true;
        AdRequest request = new AdRequest.Builder().build();
        AppOpenAd.load((Context)context, (String)this.mAdUnitId, (AdRequest)request, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(AppOpenAd ad) {
                AppOpenAds.this.appOpenAd = ad;
                AppOpenAds.this.isLoadingAd = false;
                String completeMsg = "AppOpenAd for " + AppOpenAds.this.mAdUnitId + " was loaded";
                LogUtil.e(completeMsg);
                CallbackUtil.handleCallback(callback, 201, completeMsg);
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                AppOpenAds.this.isLoadingAd = false;
                AppOpenAds.this.appOpenAd = null;
                String errorMsg = "AppOpenAd for " + AppOpenAds.this.mAdUnitId + " failed to load: " + loadAdError.getMessage() + " errorCode: " + loadAdError.getCode();
                LogUtil.e(errorMsg);
                CallbackUtil.handleCallback(callback, 1003, errorMsg);
            }
        });
    }

    @UniJSMethod(uiThread=true)
    public void showAppOpenAd(UniJSCallback callback) {
        LogUtil.e("do show google AppOpenAd.");
        this.mShowCallback = callback;
        if (!(this.mUniSDKInstance.getContext() instanceof Activity)) {
            CallbackUtil.handleCallback(this.mShowCallback, 1005, "Error, Ads cannot be displayed on the current page");
            return;
        }
        if (this.isShowingAd) {
            String completeMsg = "AppOpenAd for " + this.mAdUnitId + "failed to show: ad is already showing.";
            LogUtil.e(completeMsg);
            CallbackUtil.handleCallback(callback, 1003, completeMsg);
            return;
        }
        if (this.appOpenAd == null) {
            String msg = "The rAppOpenAd wasn't ready yet.";
            LogUtil.e(msg);
            CallbackUtil.handleCallback(this.mShowCallback, 1008, msg);
            return;
        }
        Activity activity = (Activity)this.mUniSDKInstance.getContext();
        this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

            public void onAdShowedFullScreenContent() {
                String msg = "AppOpenAd was Showed.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(AppOpenAds.this.mShowCallback, 1006, msg);
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                AppOpenAds.this.appOpenAd = null;
                AppOpenAds.this.isShowingAd = false;
                String msg = "AppOpenAd failed to show: " + adError.getMessage() + " errorCode: " + adError.getCode();
                LogUtil.e(msg);
                CallbackUtil.handleCallback(AppOpenAds.this.mShowCallback, 1004, msg);
            }

            public void onAdDismissedFullScreenContent() {
                AppOpenAds.this.appOpenAd = null;
                AppOpenAds.this.isShowingAd = false;
                String msg = "AppOpenAd was dismissed.";
                LogUtil.e(msg);
                CallbackUtil.handleCallback(AppOpenAds.this.mShowCallback, 200, msg);
            }
        });
        this.isShowingAd = true;
        this.appOpenAd.show(activity);
    }
}

