/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.manager;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.google.ads.manager.GoogleMobileAdsConsentManager;
import com.google.ads.manager.OnShowAdCompleteListener;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import java.util.Date;

class AppOpenAdManager {
    private static final String LOG_TAG = "AppOpenAdManager";
    private static final String AD_UNIT_ID = "ca-app-pub-3940256099942544/3419835294";
    private AppOpenAd appOpenAd = null;
    private boolean isLoadingAd = false;
    private boolean isShowingAd = false;
    private long loadTime = 0L;

    private void loadAd(final Context context) {
        if (this.isLoadingAd || this.isAdAvailable()) {
            return;
        }
        this.isLoadingAd = true;
        AdRequest request = new AdRequest.Builder().build();
        AppOpenAd.load((Context)context, (String)AD_UNIT_ID, (AdRequest)request, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(AppOpenAd ad) {
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)"Ad was loaded.");
                AppOpenAdManager.this.appOpenAd = ad;
                AppOpenAdManager.this.isLoadingAd = false;
                AppOpenAdManager.this.loadTime = new Date().getTime();
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)"onAdLoaded.");
                Toast.makeText((Context)context, (CharSequence)"onAdLoaded", (int)0).show();
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                AppOpenAdManager.this.isLoadingAd = false;
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)("onAdFailedToLoad: " + loadAdError.getMessage()));
                Toast.makeText((Context)context, (CharSequence)"onAdFailedToLoad", (int)0).show();
            }
        });
    }

    private boolean wasLoadTimeLessThanNHoursAgo(long numHours) {
        long numMilliSecondsPerHour;
        long dateDifference = new Date().getTime() - this.loadTime;
        return dateDifference < (numMilliSecondsPerHour = 3600000L) * numHours;
    }

    private boolean isAdAvailable() {
        return this.appOpenAd != null && this.wasLoadTimeLessThanNHoursAgo(4L);
    }

    private void showAdIfAvailable(@NonNull Activity activity) {
        this.showAdIfAvailable(activity, new OnShowAdCompleteListener(){

            @Override
            public void onShowAdComplete() {
            }
        });
    }

    private void showAdIfAvailable(final @NonNull Activity activity, final @NonNull OnShowAdCompleteListener onShowAdCompleteListener) {
        if (this.isShowingAd) {
            Log.d((String)LOG_TAG, (String)"The app open ad is already showing.");
            return;
        }
        if (!this.isAdAvailable()) {
            Log.d((String)LOG_TAG, (String)"The app open ad is not ready yet.");
            onShowAdCompleteListener.onShowAdComplete();
            if (GoogleMobileAdsConsentManager.getInstance((Context)activity).canRequestAds()) {
                this.loadAd((Context)activity);
            }
            return;
        }
        Log.d((String)LOG_TAG, (String)"Will show ad.");
        this.appOpenAd.setFullScreenContentCallback(new FullScreenContentCallback(){

            public void onAdDismissedFullScreenContent() {
                AppOpenAdManager.this.appOpenAd = null;
                AppOpenAdManager.this.isShowingAd = false;
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)"onAdDismissedFullScreenContent.");
                Toast.makeText((Context)activity, (CharSequence)"onAdDismissedFullScreenContent", (int)0).show();
                onShowAdCompleteListener.onShowAdComplete();
                if (GoogleMobileAdsConsentManager.getInstance((Context)activity).canRequestAds()) {
                    AppOpenAdManager.this.loadAd((Context)activity);
                }
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                AppOpenAdManager.this.appOpenAd = null;
                AppOpenAdManager.this.isShowingAd = false;
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)("onAdFailedToShowFullScreenContent: " + adError.getMessage()));
                Toast.makeText((Context)activity, (CharSequence)"onAdFailedToShowFullScreenContent", (int)0).show();
                onShowAdCompleteListener.onShowAdComplete();
                if (GoogleMobileAdsConsentManager.getInstance((Context)activity).canRequestAds()) {
                    AppOpenAdManager.this.loadAd((Context)activity);
                }
            }

            public void onAdShowedFullScreenContent() {
                Log.d((String)AppOpenAdManager.LOG_TAG, (String)"onAdShowedFullScreenContent.");
                Toast.makeText((Context)activity, (CharSequence)"onAdShowedFullScreenContent", (int)0).show();
            }
        });
        this.isShowingAd = true;
        this.appOpenAd.show(activity);
    }
}

