/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hms.hmsscankit.OnLightVisibleCallBack;
import com.huawei.hms.hmsscankit.RemoteView;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.ml.scan.HmsScan;
import com.lianyunzhihui.uniplugin_hwscan.FileUtils;
import com.lianyunzhihui.uniplugin_hwscan.R;
import com.lianyunzhihui.uniplugin_hwscan.ScanSizeConfig;
import java.io.IOException;
import java.util.List;

@SuppressLint(value={"ValidFragment"})
public class HWSanFragment
extends Fragment {
    final int REQUEST_CODE_PHOTO = 4371;
    private final String TAG = "HWSanFragment";
    private FrameLayout frameLayout;
    private Context mContext;
    private RemoteView remoteView;
    private ImageView flush_btn;
    private int[] img = new int[]{R.drawable.flashlight_on, R.drawable.flashlight_off};
    private List<Integer> scanTypes;
    private boolean continuou = true;
    private int sleepTime = 3;
    private View view_line;
    Handler handler = new Handler();
    private OnLightListener mOnLightListener;

    public void setContinuou(boolean continuou) {
        this.continuou = continuou;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public boolean getContinuou() {
        return this.continuou;
    }

    public RemoteView getRemoteView() {
        return this.remoteView;
    }

    public void setScanTypes(List<Integer> scanTypes) {
        this.scanTypes = scanTypes;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public HWSanFragment(Context ct) {
        Log.d((String)"HWSanFragment", (String)"onCreateView: onCreate0");
        this.mContext = ct;
    }

    @RequiresApi(api=23)
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        RemoteView.Builder mBuilder = new RemoteView.Builder();
        mBuilder.setContext(this.getActivity());
        mBuilder.enableReturnBitmap();
        if (this.scanTypes == null) {
            mBuilder.setFormat(0, new int[0]);
        } else {
            int[] types = this.listToArr(this.scanTypes);
            mBuilder.setFormat(types[0], types);
        }
        mBuilder.setContinuouslyScan(this.continuou);
        if (ScanSizeConfig.scanWeight > 0 && ScanSizeConfig.scanHeight > 0) {
            Rect rect = new Rect();
            rect.left = ScanSizeConfig.left;
            rect.right = ScanSizeConfig.right;
            rect.top = ScanSizeConfig.top + 300;
            rect.bottom = ScanSizeConfig.bottom + 300;
            mBuilder.setBoundingBox(rect);
        }
        this.remoteView = mBuilder.build();
        this.remoteView.setOnResultCallback(hmsScans -> {
            if (hmsScans.length > 0) {
                HmsScan hmsScan = hmsScans[0];
                String path = "";
                JSONObject info = FileUtils.parseResult(hmsScan);
                if (hmsScan.originalBitmap != null && ScanSizeConfig.scanResultImage) {
                    path = FileUtils.getPicturePath(hmsScan.originalBitmap, this.getActivity().getFilesDir().getAbsolutePath());
                    info.put("imgUrl", (Object)path);
                    hmsScan.originalBitmap.recycle();
                }
                Log.d((String)"HWSanFragment", (String)("onResult: " + hmsScan.getOriginalValue()));
                JSONObject RESULT = new JSONObject();
                RESULT.put("code", (Object)hmsScan.getOriginalValue());
                RESULT.put("data", (Object)info);
                RESULT.put("path", (Object)path);
                if (null != this.mOnLightListener) {
                    this.mOnLightListener.scanResult(RESULT);
                }
                if (this.continuou) {
                    this.remoteView.pauseContinuouslyScan();
                }
                this.handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        HWSanFragment.this.resumeContinuouslyScan();
                    }
                }, (long)(this.sleepTime * 1000));
            }
        });
        this.remoteView.setOnLightVisibleCallback(new OnLightVisibleCallBack(){

            public void onVisibleChanged(boolean b) {
                HWSanFragment.this.mOnLightListener.onLightVisible(b);
            }
        });
        this.remoteView.onCreate(savedInstanceState);
    }

    private int[] listToArr(List<Integer> data) {
        int[] res = new int[data.size()];
        int i = 0;
        for (Integer num : data) {
            res[i++] = num;
        }
        return res;
    }

    public void pictureScanOperation() {
        Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        pickIntent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
        this.getActivity().startActivityForResult(pickIntent, 4371);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Log.d((String)"HWSanFragment", (String)"setScanType: \u8bbe\u7f6e\u5c5e\u6027\u5148\u8fdb\u6765\u54173");
        View view = inflater.inflate(R.layout.fragment_h_w_san_fragment, null);
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.frameLayout = (FrameLayout)view.findViewById(R.id.rim);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.frameLayout.addView((View)this.remoteView, (ViewGroup.LayoutParams)params);
        this.flush_btn = (ImageView)view.findViewById(R.id.flush_btn);
        this.flush_btn.setOnClickListener(v -> {
            if (this.remoteView.getLightStatus()) {
                this.remoteView.switchLight();
                this.flush_btn.setImageResource(this.img[1]);
            } else {
                this.remoteView.switchLight();
                this.flush_btn.setImageResource(this.img[0]);
            }
        });
        ImageView scan_area = (ImageView)view.findViewById(R.id.scan_area);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)scan_area.getLayoutParams();
        layoutParams.width = ScanSizeConfig.scanWeight;
        layoutParams.height = ScanSizeConfig.scanHeight;
        layoutParams.topMargin = ScanSizeConfig.top;
        scan_area.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (ScanSizeConfig.showScanFrame) {
            scan_area.setVisibility(0);
        } else {
            scan_area.setVisibility(8);
        }
        if (ScanSizeConfig.showScanLine) {
            this.view_line = view.findViewById(R.id.view_scan_line);
            this.view_line.setVisibility(0);
            this.view_line.setBackgroundColor(Color.parseColor((String)ScanSizeConfig.scanLineColor));
            RelativeLayout.LayoutParams lineLayoutParams = (RelativeLayout.LayoutParams)this.view_line.getLayoutParams();
            lineLayoutParams.width = ScanSizeConfig.scanWeight - this.dip2px(8.0f);
            lineLayoutParams.topMargin = ScanSizeConfig.top + this.dip2px(2.0f);
            this.view_line.setLayoutParams((ViewGroup.LayoutParams)lineLayoutParams);
            TranslateAnimation animation = this.initAnimation(ScanSizeConfig.scanHeight - this.dip2px(4.0f));
            this.view_line.setAnimation((Animation)animation);
            animation.start();
        }
        Log.d((String)"HWSanFragment", (String)"onCreateView: onViewCreated3");
    }

    private TranslateAnimation initAnimation(float y) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, y);
        animation.setDuration((long)(ScanSizeConfig.lineAnimationDuration * 1000));
        animation.setRepeatCount(Integer.MAX_VALUE);
        animation.setRepeatMode(2);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        return animation;
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void switchLight() {
        this.remoteView.switchLight();
        this.mOnLightListener.lightStatu(this.remoteView.getLightStatus());
    }

    public void pauseContinuouslyScan() {
        if (this.remoteView != null) {
            this.remoteView.pauseContinuouslyScan();
        }
    }

    public void resumeContinuouslyScan() {
        if (this.remoteView != null) {
            this.remoteView.resumeContinuouslyScan();
        }
    }

    public void onStart() {
        super.onStart();
        if (this.remoteView != null) {
            this.remoteView.onStart();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.remoteView != null) {
            this.remoteView.onResume();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4371 && data != null) {
            try {
                Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.getActivity().getContentResolver(), (Uri)data.getData());
                HmsScan[] hmsScans = ScanUtil.decodeWithBitmap((Context)this.getActivity(), (Bitmap)bitmap, null);
                if (hmsScans.length > 0) {
                    HmsScan hmsScan = hmsScans[0];
                    JSONObject info = FileUtils.parseResult(hmsScan);
                    String path = "";
                    if (ScanSizeConfig.scanResultImage) {
                        path = FileUtils.getPicturePath(bitmap, this.getActivity().getFilesDir().getAbsolutePath());
                        info.put("imgUrl", (Object)path);
                    }
                    bitmap.recycle();
                    JSONObject RESULT = new JSONObject();
                    RESULT.put("code", (Object)hmsScan.getOriginalValue());
                    RESULT.put("data", (Object)info);
                    RESULT.put("path", (Object)path);
                    this.mOnLightListener.scanResult(RESULT);
                } else {
                    bitmap.recycle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void releaseAssets() {
        if (this.remoteView != null) {
            this.remoteView.onDestroy();
        }
        if (this.handler != null) {
            this.handler = null;
        }
    }

    public void remotePause() {
        if (this.remoteView != null) {
            this.remoteView.onPause();
        }
    }

    public void remoteStop() {
        if (this.remoteView != null) {
            this.remoteView.onStop();
        }
    }

    public void remoteResume() {
        if (this.remoteView != null) {
            this.remoteView.onResume();
        }
    }

    public void remoteStart() {
        if (this.remoteView != null) {
            this.remoteView.onStart();
        }
    }

    public void setmOnLightListener(OnLightListener mOnLightListener) {
        this.mOnLightListener = mOnLightListener;
    }

    public static interface OnLightListener {
        public void lightStatu(boolean var1);

        public void scanResult(JSONObject var1);

        public void onLightVisible(boolean var1);
    }
}

