/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads;

import android.content.Context;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.google.ads.utils.LogUtil;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.ui.action.AbsComponentData;
import io.dcloud.feature.uniapp.ui.component.AbsVContainer;
import io.dcloud.feature.uniapp.ui.component.UniComponent;
import io.dcloud.feature.uniapp.ui.component.UniComponentProp;
import java.util.HashMap;

public class BannerView
extends UniComponent<AdView> {
    private Context mContext;
    private String mAdUnitId = "";
    private String bannerSizeType = "";
    private AdView mAdView;

    public BannerView(UniSDKInstance instance, AbsVContainer parent, AbsComponentData componentData) {
        super(instance, parent, componentData);
    }

    protected AdView initComponentHostView(Context context) {
        this.mContext = context;
        this.mAdView = new AdView(context);
        this.mAdView.setAdListener(new AdListener(){

            public void onAdClicked() {
                super.onAdClicked();
                BannerView.this.fireEvent("onAdClicked");
                LogUtil.e("BannerView onAdClicked");
            }

            public void onAdClosed() {
                super.onAdClosed();
                BannerView.this.fireEvent("onAdClosed");
                LogUtil.e("BannerView onAdClosed");
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                LogUtil.e("BannerView onAdFailedToLoad errorCode: " + loadAdError.getCode() + "  errorMsg: " + loadAdError.getMessage());
                HashMap params = new HashMap();
                HashMap<String, Object> detail = new HashMap<String, Object>();
                detail.put("errorMessage", loadAdError.getMessage());
                detail.put("errorCode", loadAdError.getCode());
                params.put("detail", detail);
                BannerView.this.fireEvent("onAdFailedToLoad", params);
            }

            public void onAdImpression() {
                super.onAdImpression();
                BannerView.this.fireEvent("onAdImpression");
                LogUtil.e("BannerView onAdImpression");
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                BannerView.this.fireEvent("onAdLoaded");
                LogUtil.e("BannerView onAdLoaded");
            }

            public void onAdOpened() {
                super.onAdOpened();
                BannerView.this.fireEvent("onAdOpened");
                LogUtil.e("BannerView onAdOpened");
            }

            public void onAdSwipeGestureClicked() {
                super.onAdSwipeGestureClicked();
                BannerView.this.fireEvent("onAdSwipeGestureClicked");
                LogUtil.e("BannerView onAdSwipeGestureClicked");
            }
        });
        return this.mAdView;
    }

    public void destroy() {
        super.destroy();
        if (this.mAdView != null) {
            this.mAdView.destroyDrawingCache();
        }
    }

    @UniJSMethod
    public void refreshBanner() {
        if (!TextUtils.isEmpty((CharSequence)this.mAdUnitId) && !TextUtils.isEmpty((CharSequence)this.bannerSizeType)) {
            this.mAdView.setAdSize(this.getBannerSize());
            this.mAdView.setAdUnitId(this.mAdUnitId);
            AdRequest adRequest = new AdRequest.Builder().build();
            this.mAdView.loadAd(adRequest);
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)"Incomplete data!", (int)0).show();
        }
    }

    @UniComponentProp(name="type")
    public void setAdSize(String type) {
        this.bannerSizeType = type;
        LogUtil.e("bannerSizeType: " + this.bannerSizeType);
        this.doLoadBanner();
    }

    @UniComponentProp(name="adId")
    public void setAdId(String adId) {
        this.mAdUnitId = adId;
        LogUtil.e("mAdUnitId: " + this.mAdUnitId);
        this.doLoadBanner();
    }

    public void doLoadBanner() {
        Context context = this.mUniSDKInstance.getContext();
        if (TextUtils.isEmpty((CharSequence)this.mAdUnitId) || TextUtils.isEmpty((CharSequence)this.bannerSizeType)) {
            LogUtil.e("Incomplete data");
            return;
        }
        LogUtil.e("doLoadBanner function");
        this.mAdView.setAdSize(this.getBannerSize());
        this.mAdView.setAdUnitId(this.mAdUnitId);
        AdRequest adRequest = new AdRequest.Builder().build();
        this.mAdView.loadAd(adRequest);
    }

    private AdSize getBannerSize() {
        AdSize adSize = AdSize.BANNER;
        if (this.bannerSizeType.equals("2")) {
            adSize = AdSize.LARGE_BANNER;
        } else if (this.bannerSizeType.equals("3")) {
            adSize = AdSize.MEDIUM_RECTANGLE;
        } else if (this.bannerSizeType.equals("4")) {
            adSize = AdSize.FULL_BANNER;
        } else if (this.bannerSizeType.equals("5")) {
            adSize = AdSize.LEADERBOARD;
        } else if (this.bannerSizeType.equals("6")) {
            adSize = AdSize.SMART_BANNER;
        }
        return adSize;
    }
}

