/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.utils;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaPlayer;
import android.os.Vibrator;
import com.xiaoguang.widget.R;
import java.io.Closeable;

public final class BeepManager
implements MediaPlayer.OnErrorListener,
Closeable {
    private static final long VIBRATE_DURATION = 200L;
    private final Context context;
    private MediaPlayer mediaPlayer;
    private Vibrator vibrator;
    private boolean playBeep;
    private boolean vibrate;

    public BeepManager(Context context) {
        this.context = context;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public void setPlayBeep(boolean playBeep) {
        this.playBeep = playBeep;
    }

    private synchronized void updatePrefs() {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = this.buildMediaPlayer(this.context);
        }
        if (this.vibrator == null) {
            this.vibrator = (Vibrator)this.context.getSystemService("vibrator");
        }
    }

    public synchronized void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            this.vibrator.vibrate(200L);
        }
    }

    private MediaPlayer buildMediaPlayer(Context context) {
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            AssetFileDescriptor file = context.getResources().openRawResourceFd(R.raw.scan_beep);
            mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mediaPlayer.setAudioStreamType(3);
            mediaPlayer.setLooping(false);
            mediaPlayer.prepare();
            return mediaPlayer;
        }
        catch (Exception e) {
            mediaPlayer.release();
            return null;
        }
    }

    public synchronized boolean onError(MediaPlayer mp, int what, int extra) {
        this.close();
        this.updatePrefs();
        return true;
    }

    @Override
    public synchronized void close() {
        try {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

