/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.xiaoguang.widget.R;
import com.xiaoguang.widget.mlkitscanner.callback.CustomViewBindCallback;
import com.xiaoguang.widget.mlkitscanner.model.ScanConfig;

public class ScanActionMenuView
extends FrameLayout {
    private LinearLayout btn_scan_light;
    private ImageView iv_scan_light;
    private TextView tv_scan_light;
    private LinearLayout btn_close;
    private LinearLayout btn_photo;
    private RelativeLayout rl_default_menu;
    private LinearLayout ll_custom_view;
    private OnScanActionMenuListener onScanActionMenuListener;
    private ScanConfig scanConfig;

    public void setOnScanActionMenuListener(OnScanActionMenuListener onScanActionMenuListener) {
        this.onScanActionMenuListener = onScanActionMenuListener;
    }

    public ScanActionMenuView(Context context) {
        this(context, null);
    }

    public ScanActionMenuView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScanActionMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.action_scan_menu, (ViewGroup)this);
        this.btn_scan_light = (LinearLayout)this.findViewById(R.id.btn_scan_light);
        this.iv_scan_light = (ImageView)this.findViewById(R.id.iv_scan_light);
        this.tv_scan_light = (TextView)this.findViewById(R.id.tv_scan_light);
        this.btn_close = (LinearLayout)this.findViewById(R.id.btn_close);
        this.btn_photo = (LinearLayout)this.findViewById(R.id.btn_photo);
        this.rl_default_menu = (RelativeLayout)this.findViewById(R.id.rl_default_menu);
        this.ll_custom_view = (LinearLayout)this.findViewById(R.id.ll_custom_view);
        this.rl_default_menu.setVisibility(8);
        this.ll_custom_view.setVisibility(8);
        this.btn_scan_light.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ScanActionMenuView.this.onScanActionMenuListener != null) {
                    ScanActionMenuView.this.onScanActionMenuListener.onLight();
                }
            }
        });
        this.btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ScanActionMenuView.this.onScanActionMenuListener != null) {
                    ScanActionMenuView.this.onScanActionMenuListener.onClose();
                }
            }
        });
        this.btn_photo.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ScanActionMenuView.this.onScanActionMenuListener != null) {
                    ScanActionMenuView.this.onScanActionMenuListener.onPhoto();
                }
            }
        });
    }

    public void setScanConfig(ScanConfig config, CustomViewBindCallback customViewBindCallback) {
        this.scanConfig = config;
        int customShadeViewLayoutID = this.scanConfig.getCustomShadeViewLayoutID();
        if (customShadeViewLayoutID > 0 && customViewBindCallback != null) {
            this.ll_custom_view.setVisibility(0);
            View customView = LayoutInflater.from((Context)this.getContext()).inflate(customShadeViewLayoutID, null);
            this.ll_custom_view.addView(customView);
            customViewBindCallback.onBindView(customView);
        } else {
            this.rl_default_menu.setVisibility(0);
        }
        boolean showLightController = this.scanConfig.isShowLightController();
        if (showLightController) {
            this.btn_scan_light.setVisibility(0);
        } else {
            this.btn_scan_light.setVisibility(8);
        }
        if (!this.scanConfig.isShowPhotoAlbum()) {
            this.btn_photo.setVisibility(8);
        }
    }

    public void openLight() {
        this.iv_scan_light.setImageResource(R.drawable.ic_scan_flash_light_on);
        this.tv_scan_light.setText((CharSequence)"Turn off the flashlight");
    }

    public void closeLight() {
        this.iv_scan_light.setImageResource(R.drawable.ic_scan_flash_light_off);
        this.tv_scan_light.setText((CharSequence)"Turn on the flashlight");
    }

    public static interface OnScanActionMenuListener {
        public void onClose();

        public void onLight();

        public void onPhoto();
    }
}

