/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.view.SurfaceHolder;
import java.io.IOException;
import java.util.List;

public class CameraOperation {
    private static final String TAG = "CameraOperation";
    private Camera camera = null;
    private Camera.Parameters parameters = null;
    private boolean isPreview = false;
    private FrameCallback frameCallback = new FrameCallback();
    private int width = 1920;
    private int height = 1080;
    private double defaultZoom = 1.0;

    public synchronized void open(SurfaceHolder holder) throws IOException {
        this.camera = Camera.open();
        this.parameters = this.camera.getParameters();
        this.parameters.setPictureSize(this.width, this.height);
        this.parameters.setFocusMode("continuous-picture");
        this.parameters.setPictureFormat(17);
        this.camera.setPreviewDisplay(holder);
        this.camera.setDisplayOrientation(90);
        this.camera.setParameters(this.parameters);
    }

    public synchronized void close() {
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
    }

    public synchronized void startPreview() {
        if (this.camera != null && !this.isPreview) {
            this.camera.startPreview();
            this.isPreview = true;
        }
    }

    public synchronized void stopPreview() {
        if (this.camera != null && this.isPreview) {
            this.camera.stopPreview();
            this.frameCallback.setProperties(null);
            this.isPreview = false;
        }
    }

    public synchronized void callbackFrame(Handler handler, double zoomValue) {
        if (this.camera != null && this.isPreview) {
            this.frameCallback.setProperties(handler);
            if (this.camera.getParameters().isZoomSupported() && zoomValue != this.defaultZoom) {
                this.parameters.setZoom(this.convertZoomInt(zoomValue));
                this.camera.setParameters(this.parameters);
            }
            this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.frameCallback);
        }
    }

    public int convertZoomInt(double zoomValue) {
        List allZoomRatios = this.parameters.getZoomRatios();
        float maxZoom = Math.round((float)((Integer)allZoomRatios.get(allZoomRatios.size() - 1)).intValue() / 100.0f);
        if (zoomValue >= (double)maxZoom) {
            return allZoomRatios.size() - 1;
        }
        for (int i = 1; i < allZoomRatios.size(); ++i) {
            if (!((double)((Integer)allZoomRatios.get(i)).intValue() >= zoomValue * 100.0) || !((double)((Integer)allZoomRatios.get(i - 1)).intValue() <= zoomValue * 100.0)) continue;
            return i;
        }
        return -1;
    }

    class FrameCallback
    implements Camera.PreviewCallback {
        private Handler handler;

        FrameCallback() {
        }

        public void setProperties(Handler handler) {
            this.handler = handler;
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            if (this.handler != null) {
                Message message = this.handler.obtainMessage(0, camera.getParameters().getPreviewSize().width, camera.getParameters().getPreviewSize().height, (Object)data);
                message.sendToTarget();
                this.handler = null;
            }
        }
    }
}

