/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hms.hmsscankit.RemoteView;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.lianyunzhihui.uniplugin_hwscan.HWScanUtils;
import com.lianyunzhihui.uniplugin_hwscan.R;
import java.io.IOException;

public class CustomizedActivity
extends Activity
implements View.OnClickListener {
    private RemoteView remoteView;
    private FrameLayout frameLayout;
    private ImageView im_back;
    private TextView tv_title;
    private ImageView im_flashlight;
    private ImageView scan_area;
    private TextView tv_scan_message;
    private ImageView im_select_potho;
    private JSONObject scanoptions;
    private RemoteView.Builder hwBuilder;
    private int scanSize = 240;
    final int REQUEST_CODE_PHOTO = 4372;
    int[] scanTypes = new int[0];
    int mScreenWidth;
    int mScreenHeight;
    private boolean showLightBtn = false;
    private int[] img = new int[]{R.drawable.flashlight_off, R.drawable.flashlight_on};
    private boolean continuouslyScan;
    private boolean scanResultImage = false;
    private int sleep = 1;
    private int lineAnimationDuration = 3;
    private View scan_line;
    private boolean showToast;
    private String toastTitle;
    Handler handler = new Handler();

    @RequiresApi(api=24)
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_customized);
        this.im_back = (ImageView)this.findViewById(R.id.image_back);
        this.tv_title = (TextView)this.findViewById(R.id.tv_title);
        this.im_flashlight = (ImageView)this.findViewById(R.id.im_flashlight);
        this.scan_area = (ImageView)this.findViewById(R.id.scan_frame);
        this.tv_scan_message = (TextView)this.findViewById(R.id.tv_scan_message);
        this.im_select_potho = (ImageView)this.findViewById(R.id.im_select_potho);
        this.scan_line = this.findViewById(R.id.view_scan_line);
        this.im_back.setOnClickListener((View.OnClickListener)this);
        this.tv_title.setOnClickListener((View.OnClickListener)this);
        this.im_select_potho.setOnClickListener((View.OnClickListener)this);
        this.im_flashlight.setOnClickListener((View.OnClickListener)this);
        this.configScanOptions();
        this.remoteView = this.hwBuilder.build();
        this.remoteView.setOnLightVisibleCallback(b -> {
            if (b && this.showLightBtn) {
                this.im_flashlight.setVisibility(0);
            }
        });
        this.remoteView.setOnResultCallback(hmsScans -> {
            if (hmsScans.length > 0) {
                HmsScan hmsScan = hmsScans[0];
                Intent broadIntent = new Intent("com.lianyunzhihui.uniplugin_hwscan.HWScanModule.MyReceiver");
                Intent intent = new Intent();
                intent.putExtra("result", hmsScan.getOriginalValue());
                if (hmsScan.getOriginalBitmap() != null && !this.continuouslyScan && this.scanResultImage) {
                    Uri uri = Uri.parse((String)MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)hmsScan.originalBitmap, null, null));
                    intent.putExtra("potho", uri.toString());
                    broadIntent.putExtra("potho", uri.toString());
                }
                if (!this.continuouslyScan) {
                    this.setResult(-1, intent);
                    this.finish();
                } else {
                    Log.d((String)"TAG", (String)("\u626b\u63cf\u7ed3\u679c: " + hmsScan.getOriginalValue()));
                    broadIntent.putExtra("result", hmsScan.getOriginalValue());
                    this.sendBroadcast(broadIntent);
                    if (this.showToast) {
                        String massage = hmsScan.getOriginalValue();
                        if (!TextUtils.isEmpty((CharSequence)this.toastTitle)) {
                            massage = this.toastTitle;
                        }
                        Toast mToast = Toast.makeText((Context)this, (CharSequence)massage, (int)0);
                        mToast.setGravity(17, 0, 0);
                        mToast.show();
                    }
                    this.remoteView.pauseContinuouslyScan();
                    this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CustomizedActivity.this.remoteView.resumeContinuouslyScan();
                        }
                    }, (long)(this.sleep * 1000));
                }
            }
        });
        this.remoteView.onCreate(savedInstanceState);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.custom_view);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.frameLayout.addView((View)this.remoteView, (ViewGroup.LayoutParams)params);
    }

    @RequiresApi(api=24)
    private void configScanOptions() {
        this.continuouslyScan = false;
        if (this.hwBuilder == null) {
            this.hwBuilder = new RemoteView.Builder();
        }
        this.hwBuilder.setContext((Activity)this);
        this.hwBuilder.enableReturnBitmap();
        Intent intent = this.getIntent();
        if (!TextUtils.isEmpty((CharSequence)intent.getStringExtra("scanOptions"))) {
            this.scanoptions = JSON.parseObject((String)intent.getStringExtra("scanOptions"));
        }
        int[] res = new int[]{};
        if (this.scanoptions.containsKey((Object)"scanType")) {
            res = HWScanUtils.scanTypeConversion(this.scanoptions.getJSONArray("scanType"));
        }
        if (res.length > 0) {
            this.hwBuilder.setFormat(res[0], res);
            this.scanTypes = res;
        } else {
            this.hwBuilder.setFormat(0, new int[0]);
        }
        if (this.scanoptions.containsKey((Object)"scanResultImage") && this.scanoptions.getBooleanValue("scanResultImage")) {
            this.scanResultImage = true;
        }
        if (this.scanoptions.containsKey((Object)"scanTypeOptions")) {
            JSONObject scanTypeOptions = this.scanoptions.getJSONObject("scanTypeOptions");
            if (scanTypeOptions.containsKey((Object)"sleep") && scanTypeOptions.getIntValue("sleep") > 0) {
                this.sleep = scanTypeOptions.getIntValue("sleep");
            }
            if (scanTypeOptions.containsKey((Object)"lineAnimationDuration") && scanTypeOptions.getIntValue("lineAnimationDuration") > 0) {
                this.lineAnimationDuration = scanTypeOptions.getIntValue("lineAnimationDuration");
            }
            if (scanTypeOptions.containsKey((Object)"scanContinue") && scanTypeOptions.getBooleanValue("scanContinue")) {
                this.continuouslyScan = true;
                this.hwBuilder.setContinuouslyScan(true);
            } else {
                this.hwBuilder.setContinuouslyScan(false);
            }
            if (scanTypeOptions.containsKey((Object)"scanTitle")) {
                this.tv_title.setVisibility(0);
                this.tv_title.setText((CharSequence)scanTypeOptions.getString("scanTitle"));
            }
            if (scanTypeOptions.containsKey((Object)"showPhotoAlbum") && scanTypeOptions.getBooleanValue("showPhotoAlbum")) {
                this.im_select_potho.setVisibility(0);
            } else {
                this.im_select_potho.setVisibility(8);
            }
            if (scanTypeOptions.containsKey((Object)"showLight") && scanTypeOptions.getBooleanValue("showLight")) {
                this.showLightBtn = true;
                this.im_flashlight.setVisibility(0);
            } else {
                this.im_flashlight.setVisibility(8);
            }
            if (scanTypeOptions.containsKey((Object)"scanFrameSize")) {
                this.scanSize = scanTypeOptions.getIntValue("scanFrameSize");
            }
            DisplayMetrics dm = this.getResources().getDisplayMetrics();
            float density = dm.density;
            this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
            this.mScreenHeight = this.getResources().getDisplayMetrics().heightPixels;
            int scanFrameSize = (int)((float)this.scanSize * density);
            int top = this.dip2px(30.0f);
            Rect rect = new Rect();
            rect.left = this.mScreenWidth / 2 - scanFrameSize / 2;
            rect.right = this.mScreenWidth / 2 + scanFrameSize / 2;
            rect.top = this.mScreenHeight / 2 - scanFrameSize / 2 - top;
            rect.bottom = this.mScreenHeight / 2 + scanFrameSize / 2 - top;
            this.hwBuilder.setBoundingBox(rect);
            if (scanTypeOptions.containsKey((Object)"showLine") && scanTypeOptions.getBooleanValue("showLine")) {
                this.scan_line.setVisibility(0);
                RelativeLayout.LayoutParams lineLayoutParams = (RelativeLayout.LayoutParams)this.scan_line.getLayoutParams();
                lineLayoutParams.width = scanFrameSize - this.dip2px(6.0f);
                lineLayoutParams.topMargin = this.mScreenHeight / 2 - scanFrameSize / 2 + this.dip2px(2.0f) - top;
                this.scan_line.setLayoutParams((ViewGroup.LayoutParams)lineLayoutParams);
                TranslateAnimation animation = this.initAnimation(scanFrameSize - this.dip2px(4.0f));
                this.scan_line.setAnimation((Animation)animation);
                animation.start();
            } else {
                this.scan_line.setVisibility(8);
            }
            if (scanTypeOptions.containsKey((Object)"scanLineColor") && !TextUtils.isEmpty((CharSequence)scanTypeOptions.getString("scanLineColor"))) {
                this.scan_line.setBackgroundColor(Color.parseColor((String)scanTypeOptions.getString("scanLineColor")));
            }
            RelativeLayout.LayoutParams lightBtnLayoutParams = (RelativeLayout.LayoutParams)this.im_flashlight.getLayoutParams();
            lightBtnLayoutParams.topMargin = this.mScreenHeight / 2 + scanFrameSize / 2 + this.dip2px(15.0f) - top;
            this.im_flashlight.setLayoutParams((ViewGroup.LayoutParams)lightBtnLayoutParams);
            if (scanTypeOptions.containsKey((Object)"showScanFrame") && scanTypeOptions.getBooleanValue("showScanFrame")) {
                this.scan_area.setVisibility(0);
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.scan_area.getLayoutParams();
                layoutParams.width = scanFrameSize;
                layoutParams.height = scanFrameSize;
                layoutParams.topMargin = this.mScreenHeight / 2 - scanFrameSize / 2 - this.dip2px(30.0f);
                this.scan_area.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                GradientDrawable gradientDrawable = (GradientDrawable)this.getDrawable(R.drawable.alartview_color);
                if (scanTypeOptions.containsKey((Object)"scanFrameStrokeColor") && !TextUtils.isEmpty((CharSequence)scanTypeOptions.getString("scanFrameStrokeColor"))) {
                    gradientDrawable.setStroke(this.dip2px(3.0f), Color.parseColor((String)scanTypeOptions.getString("scanFrameStrokeColor")));
                }
                if (scanTypeOptions.containsKey((Object)"scanFrameBackgroudColor") && !TextUtils.isEmpty((CharSequence)scanTypeOptions.getString("scanFrameBackgroudColor"))) {
                    gradientDrawable.setColor(Color.parseColor((String)scanTypeOptions.getString("scanFrameBackgroudColor")));
                }
                if (scanTypeOptions.containsKey((Object)"scanFrameRoundedCorner")) {
                    int radius = scanTypeOptions.getIntValue("scanFrameRoundedCorner");
                    gradientDrawable.setCornerRadius((float)radius);
                }
                this.scan_area.setBackground((Drawable)gradientDrawable);
                if (scanTypeOptions.containsKey((Object)"showScanMessage") && scanTypeOptions.getBooleanValue("showScanMessage")) {
                    this.tv_scan_message.setVisibility(0);
                    RelativeLayout.LayoutParams tvLayoutParams = (RelativeLayout.LayoutParams)this.tv_scan_message.getLayoutParams();
                    tvLayoutParams.topMargin = this.mScreenHeight / 2 - scanFrameSize / 2 - this.dip2px(28.0f) - top;
                    if (scanTypeOptions.containsKey((Object)"scanMessage")) {
                        this.tv_scan_message.setText((CharSequence)scanTypeOptions.getString("scanMessage"));
                    }
                }
            }
            this.showToast = scanTypeOptions.containsKey((Object)"showToast") && scanTypeOptions.getBooleanValue("showToast");
            this.toastTitle = scanTypeOptions.containsKey((Object)"toastTitle") && !TextUtils.isEmpty((CharSequence)scanTypeOptions.getString("toastTitle")) ? scanTypeOptions.getString("toastTitle") : "";
        }
    }

    private TranslateAnimation initAnimation(float y) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, y);
        animation.setDuration((long)(this.lineAnimationDuration * 1000));
        animation.setRepeatCount(Integer.MAX_VALUE);
        animation.setRepeatMode(2);
        animation.setInterpolator((Interpolator)new LinearInterpolator());
        return animation;
    }

    public int px2dip(float pxValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    protected void onStart() {
        super.onStart();
        if (this.remoteView != null) {
            this.remoteView.onStart();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.remoteView != null) {
            this.remoteView.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.remoteView != null) {
            this.remoteView.onPause();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.remoteView != null) {
            this.remoteView.onStop();
        }
    }

    protected void onDestroy() {
        if (this.remoteView != null) {
            this.remoteView.onDestroy();
        }
        if (this.handler != null) {
            this.handler = null;
        }
        super.onDestroy();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.image_back || v.getId() == R.id.tv_title) {
            this.finish();
        }
        if (v.getId() == R.id.im_select_potho) {
            Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            pickIntent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
            this.startActivityForResult(pickIntent, 4372);
        }
        if (v.getId() == R.id.im_flashlight && this.remoteView != null) {
            this.remoteView.switchLight();
            int i = this.remoteView.getLightStatus() ? 0 : 1;
            this.im_flashlight.setImageResource(this.img[i]);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4372 && data != null) {
            try {
                Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)data.getData());
                HmsScanAnalyzerOptions.Creator creator = new HmsScanAnalyzerOptions.Creator();
                creator.setPhotoMode(true);
                creator.setHmsScanTypes(this.scanTypes[0], this.scanTypes);
                HmsScan[] hmsScans = ScanUtil.decodeWithBitmap((Context)this, (Bitmap)bitmap, (HmsScanAnalyzerOptions)creator.create());
                if (hmsScans.length > 0) {
                    HmsScan hmsScan = hmsScans[0];
                    Intent intent = new Intent();
                    intent.putExtra("result", hmsScan.getOriginalValue());
                    this.setResult(-1, intent);
                    this.finish();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

