/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Base64;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hms.ml.scan.HmsScan;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static File getSaveFile(Context context) {
        File file = new File(context.getFilesDir(), "pic.jpg");
        return file;
    }

    public static File getSaveFileString(Context context, String sdFile, String name) {
        File fileNew;
        File sd = new File(sdFile);
        if (!sd.exists()) {
            sd.mkdirs();
        }
        if ((fileNew = new File(sd, name)).exists()) {
            fileNew.delete();
        }
        try {
            fileNew.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        FileInputStream is = null;
        byte[] data = null;
        String result = null;
        try {
            is = new FileInputStream(path);
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            result = Base64.encodeToString((byte[])data, (int)0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String getPicturePath(Bitmap bitmap, String sdFile) {
        File fileNew;
        String path = System.currentTimeMillis() + ".png";
        File sd = new File(sdFile);
        if (!sd.exists()) {
            sd.mkdirs();
        }
        if ((fileNew = new File(sd, path)).exists()) {
            fileNew.delete();
        }
        try {
            fileNew.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileOutputStream fos = null;
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
        try {
            fos = new FileOutputStream(fileNew);
            fos.flush();
            fos.write(bos.toByteArray());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileNew.getPath();
    }

    public static JSONObject parseResult(HmsScan result) {
        JSONObject data = new JSONObject();
        if (result.getScanTypeForm() == HmsScan.SMS_FORM) {
            data.put("scanType", (Object)"sms");
            HmsScan.SmsContent smsContent = result.getSmsContent();
            data.put("msgContent", (Object)smsContent.getMsgContent());
            data.put("destPhoneNumber", (Object)smsContent.getDestPhoneNumber());
        } else if (result.getScanTypeForm() == HmsScan.WIFI_CONNECT_INFO_FORM) {
            data.put("scanType", (Object)"wifi");
            HmsScan.WiFiConnectionInfo wiFiConnectionInfo = result.getWiFiConnectionInfo();
            data.put("ssidNumber", (Object)wiFiConnectionInfo.getSsidNumber());
            data.put("cipherMode", (Object)wiFiConnectionInfo.getCipherMode());
            data.put("password", (Object)wiFiConnectionInfo.getPassword());
        } else if (result.getScanTypeForm() == HmsScan.EMAIL_CONTENT_FORM) {
            data.put("scanType", (Object)"email");
            HmsScan.EmailContent emailContent = result.getEmailContent();
            data.put("addressInfo", (Object)emailContent.getAddressInfo());
            data.put("AddressType", (Object)emailContent.getAddressType());
            data.put("BodyInfo", (Object)emailContent.getBodyInfo());
            data.put("SubjectInfo", (Object)emailContent.getSubjectInfo());
        } else if (result.getScanTypeForm() == HmsScan.URL_FORM) {
            data.put("scanType", (Object)"url");
            HmsScan.LinkUrl linkUrl = result.getLinkUrl();
            data.put("LinkValue", (Object)linkUrl.getLinkValue());
            data.put("Theme", (Object)linkUrl.getTheme());
        } else if (result.getScanTypeForm() == HmsScan.TEL_PHONE_NUMBER_FORM) {
            data.put("scanType", (Object)"tel_phone");
            HmsScan.TelPhoneNumber telPhoneNumber = result.getTelPhoneNumber();
            data.put("TelPhoneNumber", (Object)telPhoneNumber.getTelPhoneNumber());
            data.put("UseType", (Object)telPhoneNumber.getUseType());
        } else if (result.getScanTypeForm() == HmsScan.LOCATION_COORDINATE_FORM) {
            data.put("scanType", (Object)"location");
            HmsScan.LocationCoordinate locationCoordinate = result.getLocationCoordinate();
            data.put("Latitude", (Object)locationCoordinate.getLatitude());
            data.put("Longitude", (Object)locationCoordinate.getLongitude());
        } else if (result.getScanTypeForm() == HmsScan.DRIVER_INFO_FORM) {
            data.put("scanType", (Object)"driver");
            HmsScan.DriverInfo driverInfo = result.getDriverInfo();
            data.put("Avenue", (Object)driverInfo.getAvenue());
            data.put("CertificateNumber", (Object)driverInfo.getCertificateNumber());
            data.put("CertificateType", (Object)driverInfo.getCertificateType());
            data.put("City", (Object)driverInfo.getCity());
            data.put("DateOfBirth", (Object)driverInfo.getDateOfBirth());
            data.put("CountryOfIssue", (Object)driverInfo.getCountryOfIssue());
            data.put("DateOfExpire", (Object)driverInfo.getDateOfExpire());
            data.put("EyeColor", (Object)driverInfo.getEyeColor());
            data.put("WeightRange", (Object)driverInfo.getWeightRange());
            data.put("Height", (Object)driverInfo.getHeight());
            data.put("HairColor", (Object)driverInfo.getHairColor());
            data.put("MiddleName", (Object)driverInfo.getMiddleName());
            data.put("FamilyName", (Object)driverInfo.getFamilyName());
            data.put("DateOfIssue", (Object)driverInfo.getDateOfIssue());
            data.put("GivenName", (Object)driverInfo.getGivenName());
            data.put("Sex", (Object)driverInfo.getSex());
            data.put("ZipCode", (Object)driverInfo.getZipCode());
            data.put("Province", (Object)driverInfo.getProvince());
        } else if (result.getScanTypeForm() == HmsScan.CONTACT_DETAIL_FORM) {
            List telPhoneNumbers;
            List emailContents;
            data.put("scanType", (Object)"contact_detail");
            HmsScan.ContactDetail contactDetail = result.getContactDetail();
            data.put("ContactLinks", (Object)contactDetail.getContactLinks());
            HmsScan.PeopleName peopleName = contactDetail.getPeopleName();
            JSONObject peopleInfo = new JSONObject();
            peopleInfo.put("FamilyName", (Object)peopleName.getFamilyName());
            peopleInfo.put("GivenName", (Object)peopleName.getGivenName());
            peopleInfo.put("MiddleName", (Object)peopleName.getMiddleName());
            peopleInfo.put("FullName", (Object)peopleName.getFullName());
            peopleInfo.put("NamePrefix", (Object)peopleName.getNamePrefix());
            peopleInfo.put("NameSuffix", (Object)peopleName.getNameSuffix());
            peopleInfo.put("Spelling", (Object)peopleName.getSpelling());
            data.put("peopleName", (Object)peopleInfo);
            data.put("Title", (Object)contactDetail.getTitle());
            data.put("Company", (Object)contactDetail.getCompany());
            data.put("Note", (Object)contactDetail.getNote());
            List addressInfos = contactDetail.getAddressesInfos();
            if (addressInfos != null) {
                ArrayList<JSONObject> addressList = new ArrayList<JSONObject>();
                for (HmsScan.AddressInfo addressInfo : addressInfos) {
                    JSONObject addressInfoDict = new JSONObject();
                    addressInfoDict.put("AddressType", (Object)addressInfo.getAddressType());
                    addressInfoDict.put("AddressDetails", (Object)addressInfo.getAddressDetails());
                    addressList.add(addressInfoDict);
                }
                data.put("AddressesInfos", addressList);
            }
            if ((emailContents = contactDetail.getEmailContents()) != null) {
                ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                for (HmsScan.EmailContent emailContent : emailContents) {
                    JSONObject info = new JSONObject();
                    info.put("SubjectInfo", (Object)emailContent.getSubjectInfo());
                    info.put("BodyInfo", (Object)emailContent.getBodyInfo());
                    info.put("AddressInfo", (Object)emailContent.getAddressInfo());
                    info.put("AddressType", (Object)emailContent.getAddressType());
                    list.add(info);
                }
                data.put("EmailContents", list);
            }
            if ((telPhoneNumbers = contactDetail.getTelPhoneNumbers()) != null) {
                ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                for (HmsScan.TelPhoneNumber telPhoneNumber : telPhoneNumbers) {
                    JSONObject info = new JSONObject();
                    info.put("UseType", (Object)telPhoneNumber.getUseType());
                    info.put("TelPhoneNumber", (Object)telPhoneNumber.getTelPhoneNumber());
                    list.add(info);
                }
                data.put("TelPhoneNumbers", list);
            }
        } else if (result.getScanTypeForm() == HmsScan.EVENT_INFO_FORM) {
            data.put("scanType", (Object)"event_info");
            HmsScan.EventInfo eventInfo = result.getEventInfo();
            data.put("AbstractInfo", (Object)eventInfo.getAbstractInfo());
            data.put("Theme", (Object)eventInfo.getTheme());
            data.put("PlaceInfo", (Object)eventInfo.getPlaceInfo());
            data.put("Condition", (Object)eventInfo.getCondition());
            data.put("Sponsor", (Object)eventInfo.getSponsor());
            HmsScan.EventTime startTime = eventInfo.getBeginTime();
            JSONObject startTimeDict = new JSONObject();
            startTimeDict.put("OriginalValue", (Object)startTime.getOriginalValue());
            startTimeDict.put("Day", (Object)startTime.getDay());
            startTimeDict.put("Hours", (Object)startTime.getHours());
            startTimeDict.put("Minutes", (Object)startTime.getMinutes());
            startTimeDict.put("Month", (Object)startTime.getMonth());
            startTimeDict.put("Year", (Object)startTime.getYear());
            startTimeDict.put("Seconds", (Object)startTime.getSeconds());
            data.put("startTime", (Object)startTimeDict);
            HmsScan.EventTime closeTime = eventInfo.getCloseTime();
            JSONObject closeTimeDict = new JSONObject();
            closeTimeDict.put("OriginalValue", (Object)closeTime.getOriginalValue());
            closeTimeDict.put("Day", (Object)closeTime.getDay());
            closeTimeDict.put("Hours", (Object)closeTime.getHours());
            closeTimeDict.put("Minutes", (Object)closeTime.getMinutes());
            closeTimeDict.put("Month", (Object)closeTime.getMonth());
            closeTimeDict.put("Year", (Object)closeTime.getYear());
            closeTimeDict.put("Seconds", (Object)closeTime.getSeconds());
            data.put("closeTime", (Object)closeTimeDict);
        } else if (result.getScanTypeForm() == HmsScan.ISBN_NUMBER_FORM) {
            data.put("scanType", (Object)"isbn");
            data.put("message", (Object)result.getOriginalValue());
        } else if (result.getScanTypeForm() == HmsScan.PURE_TEXT_FORM) {
            data.put("scanType", (Object)"text");
            data.put("message", (Object)result.getOriginalValue());
        } else if (result.getScanTypeForm() == HmsScan.ARTICLE_NUMBER_FORM) {
            data.put("scanType", (Object)"article");
            data.put("message", (Object)result.getOriginalValue());
        }
        return data;
    }
}

