/*
 * Decompiled with CFR 0.152.
 */
package com.lianyunzhihui.uniplugin_hwscan;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.hms.hmsscankit.ScanUtil;
import com.huawei.hms.hmsscankit.WriterException;
import com.huawei.hms.ml.scan.HmsScan;
import com.huawei.hms.ml.scan.HmsScanAnalyzerOptions;
import com.lianyunzhihui.uniplugin_hwscan.CustomizedActivity;
import com.lianyunzhihui.uniplugin_hwscan.HWScanUtils;
import com.lianyunzhihui.uniplugin_hwscan.MulitiprocessorActivity;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.io.File;
import java.io.IOException;

public class HWScanModule
extends UniModule {
    private final String TAG = "HWScanModule";
    private final int REQUEST_CODE_SCAN = 100;
    final int CAMERA_REQ_CODE = 2;
    final int PERMISSIONS_LENGTH = 2;
    final int CUSTOMIZED_SCAN = 4373;
    public final int MULTIPROCESSOR_SCAN = 4374;
    final int BITMAP_SCAN = 4375;
    private JSONObject scanOptions;
    private HmsScanAnalyzerOptions.Creator creator;
    private UniJSCallback mCallback;
    private final String prefixStr = "data:image/jpeg;base64,";
    private int[] res;
    private MyReceiver receiver;

    @UniJSMethod(uiThread=true)
    public void generatingCode(JSONObject options, UniJSCallback callback) {
        JSONObject object = new JSONObject();
        if (!options.containsKey((Object)"width") || !options.containsKey((Object)"height")) {
            object.put("msg", (Object)"\u8bf7\u4f20\u5165\u751f\u6210\u7801\u7684\u5bbd\u9ad8");
            callback.invokeAndKeepAlive((Object)object);
            return;
        }
        if (!options.containsKey((Object)"content") || TextUtils.isEmpty((CharSequence)options.getString("content"))) {
            object.put("msg", (Object)"content\u4e0d\u80fd\u4e3a\u7a7a");
            callback.invokeAndKeepAlive((Object)object);
            return;
        }
        if (!options.containsKey((Object)"codeType") || TextUtils.isEmpty((CharSequence)options.getString("codeType"))) {
            object.put("msg", (Object)"codeType\u4e0d\u80fd\u4e3a\u7a7a");
            callback.invokeAndKeepAlive((Object)object);
            return;
        }
        String content = options.getString("content");
        int width = options.getIntValue("width");
        int height = options.getIntValue("height");
        int type = HWScanUtils.searchCodeTypeWithStr(options.getString("codeType"));
        try {
            Bitmap qrBitmap = ScanUtil.buildBitmap((String)content, (int)type, (int)width, (int)height, null);
            String base64 = "data:image/jpeg;base64," + HWScanUtils.bitmapToBase64(qrBitmap);
            object.put("msg", (Object)"success");
            object.put("photo", (Object)base64);
            callback.invokeAndKeepAlive((Object)object);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
    }

    @UniJSMethod(uiThread=true)
    @RequiresApi(api=23)
    public void hwScan(JSONObject options, UniJSCallback callback) {
        Log.d((String)"HWScanModule", (String)("hwScan: " + options));
        this.mCallback = callback;
        if (options != null && options.containsKey((Object)"scanOptions")) {
            this.scanOptions = options.getJSONObject("scanOptions");
        }
        ((Activity)this.mUniSDKInstance.getContext()).requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE"}, 2);
    }

    @RequiresApi(api=24)
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        JSONObject object;
        HmsScan obj;
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100 && data != null && (obj = (HmsScan)data.getParcelableExtra("SCAN_RESULT")) != null) {
            JSONObject object2 = new JSONObject();
            object2.put("result", (Object)obj.getOriginalValue());
            this.mCallback.invokeAndKeepAlive((Object)object2);
        }
        if (requestCode == 4373 && resultCode == -1 && data != null) {
            object = new JSONObject();
            object.put("result", (Object)data.getStringExtra("result"));
            if (!TextUtils.isEmpty((CharSequence)data.getStringExtra("potho"))) {
                Uri uri = Uri.parse((String)data.getStringExtra("potho"));
                try {
                    Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)((Activity)this.mUniSDKInstance.getContext()).getContentResolver(), (Uri)uri);
                    String base64 = "data:image/jpeg;base64," + HWScanUtils.bitmapToBase64(bitmap);
                    object.put("photo", (Object)base64);
                    bitmap.recycle();
                    Log.d((String)"HWScanModule", (String)("onActivityResult: " + base64));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.mCallback.invokeAndKeepAlive((Object)object);
        }
        if (requestCode == 4375 && resultCode == -1 && data != null) {
            HmsScanAnalyzerOptions.Creator creator = new HmsScanAnalyzerOptions.Creator();
            int[] res = new int[]{};
            if (this.scanOptions.containsKey((Object)"scanType")) {
                res = HWScanUtils.scanTypeConversion(this.scanOptions.getJSONArray("scanType"));
            }
            if (res.length > 0) {
                creator.setHmsScanTypes(res[0], res);
            } else {
                creator.setHmsScanTypes(0, new int[0]);
            }
            try {
                HmsScan[] hmsScans = ScanUtil.decodeWithBitmap((Context)((Activity)this.mUniSDKInstance.getContext()), (Bitmap)MediaStore.Images.Media.getBitmap((ContentResolver)((Activity)this.mUniSDKInstance.getContext()).getContentResolver(), (Uri)data.getData()), (HmsScanAnalyzerOptions)creator.setPhotoMode(true).create());
                if (hmsScans != null && hmsScans.length > 0 && hmsScans[0] != null && !TextUtils.isEmpty((CharSequence)hmsScans[0].getOriginalValue())) {
                    JSONObject object3 = new JSONObject();
                    object3.put("result", (Object)hmsScans[0].getOriginalValue());
                    this.mCallback.invokeAndKeepAlive((Object)object3);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (requestCode == 4374 && resultCode == -1 && data != null) {
            object = new JSONObject();
            if (data.getBooleanExtra("list", false)) {
                Log.d((String)"HWScanModule", (String)("onActivityResult: " + data.getStringArrayListExtra("result")));
                object.put("result", (Object)data.getStringArrayListExtra("result"));
            } else {
                object.put("result", (Object)data.getStringExtra("result"));
            }
            this.mCallback.invokeAndKeepAlive((Object)object);
        }
    }

    @RequiresApi(api=24)
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 2 && grantResults.length == 2 && grantResults[0] == 0 && grantResults[1] == 0 && this.scanOptions != null) {
            int[] res = new int[]{};
            if (this.scanOptions.containsKey((Object)"scanType")) {
                res = HWScanUtils.scanTypeConversion(this.scanOptions.getJSONArray("scanType"));
            }
            if (this.scanOptions.getString("scanMode").equals("defaultMode")) {
                if (this.creator == null) {
                    this.creator = new HmsScanAnalyzerOptions.Creator();
                }
                if (res.length > 0) {
                    this.creator.setHmsScanTypes(res[0], res);
                } else {
                    this.creator.setHmsScanTypes(0, new int[0]);
                }
                HmsScanAnalyzerOptions hmsOptions = this.creator.setViewType(1).create();
                ScanUtil.startScan((Activity)((Activity)this.mUniSDKInstance.getContext()), (int)100, (HmsScanAnalyzerOptions)hmsOptions);
            } else if (this.scanOptions.getString("scanMode").equals("customizedMode")) {
                if (this.receiver == null) {
                    this.receiver = new MyReceiver();
                    ((Activity)this.mUniSDKInstance.getContext()).registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.lianyunzhihui.uniplugin_hwscan.HWScanModule.MyReceiver"));
                }
                Intent intent = new Intent();
                intent.putExtra("scanOptions", JSON.toJSONString((Object)this.scanOptions));
                intent.setClass(this.mUniSDKInstance.getContext(), CustomizedActivity.class);
                ((Activity)this.mUniSDKInstance.getContext()).startActivityForResult(intent, 4373);
            } else if (this.scanOptions.getString("scanMode").equals("multiProcessorMode")) {
                Intent intent = new Intent();
                intent.putExtra("scanOptions", JSON.toJSONString((Object)this.scanOptions));
                intent.putExtra("mode", 3);
                intent.setClass(this.mUniSDKInstance.getContext(), MulitiprocessorActivity.class);
                ((Activity)this.mUniSDKInstance.getContext()).startActivityForResult(intent, 4374);
            } else if (this.scanOptions.getString("scanMode").equals("BitmapMode")) {
                Intent pickIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                pickIntent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "image/*");
                ((Activity)this.mUniSDKInstance.getContext()).startActivityForResult(pickIntent, 4375);
            } else if (this.scanOptions.getString("scanMode").equals("Base64")) {
                String base64Str = this.scanOptions.getString("pictureBase64");
                Log.d((String)"HWScanModule", (String)("onRequestPermissionsResult: " + base64Str + this.scanOptions));
                Bitmap bitmap = HWScanUtils.base64ToBitmap(base64Str);
                HmsScan[] hmsScans = ScanUtil.decodeWithBitmap((Context)((Activity)this.mUniSDKInstance.getContext()), (Bitmap)bitmap, (HmsScanAnalyzerOptions)new HmsScanAnalyzerOptions.Creator().setHmsScanTypes(0, new int[0]).setPhotoMode(true).create());
                if (hmsScans.length > 0 && hmsScans != null && hmsScans.length > 0 && hmsScans[0] != null && !TextUtils.isEmpty((CharSequence)hmsScans[0].getOriginalValue())) {
                    JSONObject object = new JSONObject();
                    object.put("result", (Object)hmsScans[0].getOriginalValue());
                    this.mCallback.invokeAndKeepAlive((Object)object);
                }
            }
        }
    }

    @UniJSMethod(uiThread=true)
    public void clearCacheWithFilePath(String filePath, UniJSCallback callback) {
        JSONObject object = new JSONObject();
        if (filePath == null || TextUtils.isEmpty((CharSequence)filePath)) {
            object.put("result", (Object)false);
        } else {
            File file = new File(filePath);
            boolean delete = file.delete();
            Log.d((String)"HWScanModule", (String)("clearCacheWithFilePath: " + filePath));
            Log.d((String)"HWScanModule", (String)("\u7ed3\u679c: " + delete));
            object.put("result", (Object)delete);
        }
        callback.invokeAndKeepAlive((Object)object);
    }

    public void onActivityDestroy() {
        if (this.receiver != null) {
            ((Activity)this.mUniSDKInstance.getContext()).unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        super.onActivityDestroy();
    }

    public class MyReceiver
    extends BroadcastReceiver {
        public static final String ACTION = "com.lianyunzhihui.uniplugin_hwscan.HWScanModule.MyReceiver";

        public void onReceive(Context context, Intent intent) {
            String result = intent.getStringExtra("result");
            if (HWScanModule.this.mCallback != null) {
                JSONObject object = new JSONObject();
                object.put("result", (Object)result);
                HWScanModule.this.mCallback.invokeAndKeepAlive((Object)object);
            }
        }
    }
}

