/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    private static void determineFirstDigit(StringBuilder stringBuilder, int n2) throws NotFoundException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (n2 != FIRST_DIGIT_ENCODINGS[i2]) continue;
            stringBuilder.insert(0, (char)(i2 + 48));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n2;
        int n3;
        int[] nArray2 = ((EAN13Reader)object).decodeMiddleCounters;
        Object object = nArray2;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        ((EAN13Reader)object).decodeMiddleCounters[3] = 0;
        int n4 = bitArray.getSize();
        int n5 = nArray[1];
        int n6 = 0;
        for (n3 = 0; n3 < 6 && n5 < n4; ++n3) {
            n2 = UPCEANReader.decodeDigit(bitArray, (int[])object, n5, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(n2 % 10 + 48));
            int n7 = ((Object)object).length;
            for (int i2 = 0; i2 < n7; ++i2) {
                n5 += object[i2];
            }
            if (n2 < 10) continue;
            n6 |= 1 << 5 - n3;
        }
        EAN13Reader.determineFirstDigit(stringBuilder, n6);
        n5 = UPCEANReader.findGuardPattern(bitArray, n5, true, UPCEANReader.MIDDLE_PATTERN)[1];
        for (n6 = 0; n6 < 6 && n5 < n4; ++n6) {
            stringBuilder.append((char)(UPCEANReader.decodeDigit(bitArray, (int[])object, n5, UPCEANReader.L_PATTERNS) + 48));
            n3 = ((Object)object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                n5 += object[n2];
            }
        }
        return n5;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }
}

