/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.graphics.Bitmap;
import com.nostra13.dcloudimageloader.core.ImageLoaderEngine;
import com.nostra13.dcloudimageloader.core.ImageLoadingInfo;
import com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.utils.L;

final class DisplayBitmapTask
implements Runnable {
    private static final String LOG_DISPLAY_IMAGE_IN_IMAGEAWARE = "Display image in ImageAware (loaded from %1$s) [%2$s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_REUSED = "ImageAware is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED = "ImageAware was collected by GC. Task is cancelled. [%s]";
    private final Bitmap bitmap;
    private final String imageUri;
    private final ImageAware imageAware;
    private final String memoryCacheKey;
    private final BitmapDisplayer displayer;
    private final ImageLoadingListener listener;
    private final ImageLoaderEngine engine;
    private final LoadedFrom loadedFrom;
    private boolean loggingEnabled;

    public DisplayBitmapTask(Bitmap bitmap, ImageLoadingInfo imageLoadingInfo, ImageLoaderEngine imageLoaderEngine, LoadedFrom loadedFrom) {
        this.bitmap = bitmap;
        this.imageUri = imageLoadingInfo.uri;
        this.imageAware = imageLoadingInfo.imageAware;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.displayer = imageLoadingInfo.options.getDisplayer();
        this.listener = imageLoadingInfo.listener;
        this.engine = imageLoaderEngine;
        this.loadedFrom = loadedFrom;
    }

    private boolean isViewWasReused() {
        DisplayBitmapTask displayBitmapTask = string2;
        String string2 = displayBitmapTask.engine.getLoadingUriForView(((DisplayBitmapTask)((Object)string2)).imageAware);
        return displayBitmapTask.memoryCacheKey.equals(string2) ^ true;
    }

    @Override
    public void run() {
        if (this.imageAware.isCollected()) {
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = this.memoryCacheKey;
                L.d(LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED, objectArray2);
            }
            this.listener.onLoadingCancelled(this.imageUri, this.imageAware.getWrappedView());
        } else if (this.isViewWasReused()) {
            if (this.loggingEnabled) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = this.memoryCacheKey;
                L.d(LOG_TASK_CANCELLED_IMAGEAWARE_REUSED, objectArray3);
            }
            this.listener.onLoadingCancelled(this.imageUri, this.imageAware.getWrappedView());
        } else {
            Bitmap bitmap;
            if (this.loggingEnabled) {
                Bitmap bitmap2 = new Object[2];
                bitmap = bitmap2;
                bitmap[0] = this.loadedFrom;
                bitmap2[1] = this.memoryCacheKey;
                L.d(LOG_DISPLAY_IMAGE_IN_IMAGEAWARE, (Object[])bitmap);
            }
            DisplayBitmapTask displayBitmapTask = this;
            DisplayBitmapTask displayBitmapTask2 = this;
            bitmap = displayBitmapTask2.bitmap;
            ImageAware imageAware = displayBitmapTask2.imageAware;
            LoadedFrom loadedFrom = displayBitmapTask2.loadedFrom;
            bitmap = displayBitmapTask.displayer.display(bitmap, imageAware, loadedFrom);
            displayBitmapTask.listener.onLoadingComplete(this.imageUri, this.imageAware.getWrappedView(), bitmap);
            displayBitmapTask.engine.cancelDisplayTaskFor(this.imageAware);
        }
    }

    void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }
}

