/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.CacheRequest;
import dc.squareup.okhttp3.internal.cache.CacheStrategy;
import dc.squareup.okhttp3.internal.cache.InternalCache;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import dc.squareup.okhttp3.internal.http.RealResponseBody;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public final class CacheInterceptor
implements Interceptor {
    final InternalCache cache;

    public CacheInterceptor(InternalCache internalCache) {
        this.cache = internalCache;
    }

    private static Response stripBody(Response response) {
        if (response != null && response.body() != null) {
            response = response.newBuilder().body(null).build();
        }
        return response;
    }

    private Response cacheWritingResponse(CacheRequest cacheRequest, Response closeable) throws IOException {
        Source source;
        if (cacheRequest == null) {
            return closeable;
        }
        Sink sink = cacheRequest.body();
        if (sink == null) {
            return closeable;
        }
        Response response = closeable;
        closeable = closeable.body().source();
        sink = Okio.buffer(sink);
        Source source2 = source;
        source = new Source((BufferedSource)closeable, cacheRequest, (BufferedSink)sink){
            boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource val$source;
            final /* synthetic */ CacheRequest val$cacheRequest;
            final /* synthetic */ BufferedSink val$cacheBody;
            {
                this.val$source = bufferedSource;
                this.val$cacheRequest = cacheRequest;
                this.val$cacheBody = bufferedSink;
            }

            @Override
            public long read(Buffer buffer, long l2) throws IOException {
                block3: {
                    block4: {
                        try {
                            l2 = this.val$source.read(buffer, l2);
                            if (l2 != -1L) break block3;
                            if (this.cacheRequestClosed) break block4;
                            this.cacheRequestClosed = true;
                        }
                        catch (IOException iOException) {
                            if (!this.cacheRequestClosed) {
                                this.cacheRequestClosed = true;
                                this.val$cacheRequest.abort();
                            }
                            throw iOException;
                        }
                        this.val$cacheBody.close();
                    }
                    return -1L;
                }
                buffer.copyTo(this.val$cacheBody.buffer(), buffer.size() - l2, l2);
                this.val$cacheBody.emitCompleteSegments();
                return l2;
            }

            @Override
            public Timeout timeout() {
                return this.val$source.timeout();
            }

            @Override
            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.val$cacheRequest.abort();
                }
                this.val$source.close();
            }
        };
        Object object = response.header("Content-Type");
        long l2 = response.body().contentLength();
        Object object2 = object;
        object = Okio.buffer(source2);
        return response.newBuilder().body(new RealResponseBody((String)object2, l2, (BufferedSource)object)).build();
    }

    private static Headers combine(Headers headers, Headers headers2) {
        int n2;
        Headers.Builder builder;
        Headers.Builder builder2 = builder;
        builder = new Headers.Builder();
        int n3 = headers.size();
        for (n2 = 0; n2 < n3; ++n2) {
            String string2 = headers.name(n2);
            String string3 = headers.value(n2);
            if ("Warning".equalsIgnoreCase(string2) && string3.startsWith("1") || !CacheInterceptor.isContentSpecificHeader(string2) && CacheInterceptor.isEndToEnd(string2) && headers2.get(string2) != null) continue;
            Internal.instance.addLenient(builder2, string2, string3);
        }
        n2 = headers2.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = headers2.name(i2);
            if (CacheInterceptor.isContentSpecificHeader(string4) || !CacheInterceptor.isEndToEnd(string4)) continue;
            Internal.instance.addLenient(builder2, string4, headers2.value(i2));
        }
        return builder2.build();
    }

    static boolean isEndToEnd(String string2) {
        return !"Connection".equalsIgnoreCase(string2) && !"Keep-Alive".equalsIgnoreCase(string2) && !"Proxy-Authenticate".equalsIgnoreCase(string2) && !"Proxy-Authorization".equalsIgnoreCase(string2) && !"TE".equalsIgnoreCase(string2) && !"Trailers".equalsIgnoreCase(string2) && !"Transfer-Encoding".equalsIgnoreCase(string2) && !"Upgrade".equalsIgnoreCase(string2);
    }

    static boolean isContentSpecificHeader(String string2) {
        return "Content-Length".equalsIgnoreCase(string2) || "Content-Encoding".equalsIgnoreCase(string2) || "Content-Type".equalsIgnoreCase(string2);
    }

    @Override
    public Response intercept(Interceptor.Chain object) throws IOException {
        Request request;
        Object object2;
        Object object3;
        block14: {
            object3 = this.cache;
            object3 = object3 != null ? object3.get(object.request()) : null;
            long l2 = System.currentTimeMillis();
            object2 = object.request();
            CacheStrategy cacheStrategy = new CacheStrategy.Factory(l2, (Request)object2, (Response)object3).get();
            request = cacheStrategy.networkRequest;
            object2 = cacheStrategy.cacheResponse;
            InternalCache internalCache = this.cache;
            if (internalCache != null) {
                internalCache.trackResponse(cacheStrategy);
            }
            if (object3 != null && object2 == null) {
                Util.closeQuietly(((Response)object3).body());
            }
            if (request == null && object2 == null) {
                return new Response.Builder().request(object.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
            }
            if (request == null) {
                return ((Response)object2).newBuilder().cacheResponse(CacheInterceptor.stripBody((Response)object2)).build();
            }
            try {
                object = object.proceed(request);
                if (object != null || object3 == null) break block14;
            }
            catch (Throwable throwable) {
                if (object3 != null) {
                    Util.closeQuietly(((Response)object3).body());
                }
                throw throwable;
            }
            Util.closeQuietly(((Response)object3).body());
        }
        if (object2 != null) {
            if (((Response)object).code() == 304) {
                object3 = ((Response)object2).newBuilder().headers(CacheInterceptor.combine(((Response)object2).headers(), ((Response)object).headers())).sentRequestAtMillis(((Response)object).sentRequestAtMillis()).receivedResponseAtMillis(((Response)object).receivedResponseAtMillis()).cacheResponse(CacheInterceptor.stripBody((Response)object2)).networkResponse(CacheInterceptor.stripBody((Response)object)).build();
                CacheInterceptor cacheInterceptor = this;
                ((Response)object).body().close();
                cacheInterceptor.cache.trackConditionalCacheHit();
                cacheInterceptor.cache.update((Response)object2, (Response)object3);
                return object3;
            }
            Util.closeQuietly(((Response)object2).body());
        }
        object = ((Response)object).newBuilder().cacheResponse(CacheInterceptor.stripBody((Response)object2)).networkResponse(CacheInterceptor.stripBody((Response)object)).build();
        if (this.cache != null) {
            if (HttpHeaders.hasBody((Response)object) && CacheStrategy.isCacheable((Response)object, request)) {
                CacheInterceptor cacheInterceptor = this;
                return cacheInterceptor.cacheWritingResponse(cacheInterceptor.cache.put((Response)object), (Response)object);
            }
            if (HttpMethod.invalidatesCache(request.method())) {
                try {
                    this.cache.remove(request);
                }
                catch (IOException iOException) {}
            }
        }
        return object;
    }
}

