/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.FaultHidingSink;
import dc.squareup.okhttp3.internal.io.FileSystem;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable,
Flushable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    static final /* synthetic */ boolean $assertionsDisabled;
    final FileSystem fileSystem;
    final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    final int valueCount;
    private long size = 0L;
    BufferedSink journalWriter;
    final LinkedHashMap<String, Entry> lruEntries;
    int redundantOpCount;
    boolean hasJournalErrors;
    boolean initialized;
    boolean closed;
    boolean mostRecentTrimFailed;
    boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final Executor executor;
    private final Runnable cleanupRunnable;

    DiskLruCache(FileSystem fileSystem, File file, int n2, int n3, long l2, Executor executor) {
        File file2;
        File file3;
        File file4;
        Runnable runnable;
        LinkedHashMap linkedHashMap;
        Object object = linkedHashMap;
        linkedHashMap = new LinkedHashMap(0, 0.75f, true);
        ((DiskLruCache)object2).lruEntries = object;
        ((DiskLruCache)object2).nextSequenceNumber = 0L;
        object = runnable;
        runnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        ((DiskLruCache)object2).cleanupRunnable = object;
        ((DiskLruCache)object2).fileSystem = fileSystem;
        ((DiskLruCache)object2).directory = file;
        ((DiskLruCache)object2).appVersion = n2;
        Object object2 = file4;
        file4 = new File(file, JOURNAL_FILE);
        v3.journalFile = object2;
        object2 = file3;
        file3 = new File(file, JOURNAL_FILE_TEMP);
        v3.journalFileTmp = object2;
        object2 = file2;
        file2 = new File(file, JOURNAL_FILE_BACKUP);
        v3.journalFileBackup = object2;
        v3.valueCount = n3;
        v3.maxSize = l2;
        v3.executor = executor;
    }

    public static DiskLruCache create(FileSystem fileSystem, File file, int n2, int n3, long l2) {
        if (l2 > 0L) {
            if (n3 > 0) {
                LinkedBlockingQueue<Runnable> linkedBlockingQueue;
                ThreadPoolExecutor threadPoolExecutor;
                ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
                TimeUnit timeUnit = TimeUnit.SECONDS;
                LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
                linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
                ThreadFactory threadFactory = Util.threadFactory("OkHttp DiskLruCache", true);
                threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, timeUnit, linkedBlockingQueue2, threadFactory);
                return new DiskLruCache(fileSystem, file, n2, n3, l2, threadPoolExecutor2);
            }
            throw new IllegalArgumentException("valueCount <= 0");
        }
        throw new IllegalArgumentException("maxSize <= 0");
    }

    /*
     * Unable to fully structure code
     */
    private void readJournal() throws IOException {
        block18: {
            var1_1 = Okio.buffer(this.fileSystem.source(this.journalFile));
            var2_2 = var1_1.readUtf8LineStrict();
            var3_4 = var1_1.readUtf8LineStrict();
            var4_5 = var1_1.readUtf8LineStrict();
            var5_6 = var1_1.readUtf8LineStrict();
            var6_7 = var1_1.readUtf8LineStrict();
            if (!"libcore.io.DiskLruCache".equals(var2_2)) break block18;
            if (!"1".equals(var3_4)) break block18;
            if (!Integer.toString(this.appVersion).equals(var4_5)) break block18;
            if (!Integer.toString(this.valueCount).equals(var5_6)) break block18;
            if (!"".equals(var6_7)) break block18;
            var2_3 = 0;
            while (true) {
                try {
                    this.readJournalLine(var1_1.readUtf8LineStrict());
                    ++var2_3;
                }
                catch (EOFException v0) {
                    block19: {
                        v1 = var1_1;
                        v2 = this;
                        v3 = var2_3 - this.lruEntries.size();
                        v2.redundantOpCount = v3;
                        if (v1.exhausted()) ** GOTO lbl39
                        this.rebuildJournal();
                        break block19;
lbl39:
                        // 1 sources

                        this.journalWriter = this.newJournalWriter();
                    }
                    Util.closeQuietly(var1_1);
                    return;
                }
            }
        }
        throw new IOException("unexpected journal header: [" + var2_2 + ", " + var3_4 + ", " + var5_6 + ", " + var6_7 + "]");
        {
            catch (Throwable v4) {
                Util.closeQuietly(var1_1);
                throw v4;
            }
        }
    }

    private BufferedSink newJournalWriter() throws FileNotFoundException {
        Sink sink = this.fileSystem.appendingSink(this.journalFile);
        return Okio.buffer(new FaultHidingSink(sink){
            static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = DiskLruCache.class.desiredAssertionStatus() ^ true;
            }

            @Override
            protected void onException(IOException iOException) {
                if (!$assertionsDisabled && !Thread.holdsLock(DiskLruCache.this)) {
                    throw new AssertionError();
                }
                DiskLruCache.this.hasJournalErrors = true;
            }
        });
    }

    private void readJournalLine(String object) throws IOException {
        block8: {
            block12: {
                block10: {
                    int n2;
                    int n3;
                    block11: {
                        Editor editor;
                        Entry entry;
                        block9: {
                            String string2;
                            n3 = ((String)object).indexOf(32);
                            if (n3 == -1) break block8;
                            int n4 = n3 + 1;
                            n2 = ((String)object).indexOf(32, n4);
                            if (n2 == -1) {
                                string2 = ((String)object).substring(n4);
                                if (n3 == 6 && ((String)object).startsWith(REMOVE)) {
                                    stringArray.lruEntries.remove(string2);
                                    return;
                                }
                            } else {
                                string2 = ((String)object).substring(n4, n2);
                            }
                            if ((entry = stringArray.lruEntries.get(string2)) == null) {
                                Entry entry2;
                                entry = entry2;
                                entry2 = new Entry((DiskLruCache)stringArray, string2);
                                stringArray.lruEntries.put(string2, entry);
                            }
                            if (n2 == -1 || n3 != 5 || !((String)object).startsWith(CLEAN)) break block9;
                            String[] stringArray = ((String)object).substring(n2 + 1).split(" ");
                            entry.readable = true;
                            entry.currentEditor = null;
                            entry.setLengths(stringArray);
                            break block10;
                        }
                        if (n2 != -1 || n3 != 5 || !((String)object).startsWith(DIRTY)) break block11;
                        object = editor;
                        editor = (DiskLruCache)stringArray.new Editor(entry);
                        entry.currentEditor = object;
                        break block10;
                    }
                    if (n2 != -1 || n3 != 4 || !((String)object).startsWith(READ)) break block12;
                }
                return;
            }
            throw new IOException("unexpected journal line: " + (String)object);
        }
        throw new IOException("unexpected journal line: " + (String)object);
    }

    private void processJournal() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.fileSystem.delete(this.journalFileTmp);
        Iterator<Entry> iterator = diskLruCache.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                DiskLruCache diskLruCache2 = this;
                diskLruCache2.fileSystem.delete(entry.cleanFiles[n2]);
                diskLruCache2.fileSystem.delete(entry.dirtyFiles[n2]);
            }
            iterator.remove();
        }
    }

    private synchronized void checkNotClosed() {
        if (!this.isClosed()) {
            return;
        }
        throw new IllegalStateException("cache is closed");
    }

    private void validateKey(String string2) {
        if (LEGAL_KEY_PATTERN.matcher(string2).matches()) {
            return;
        }
        throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,120}: \"" + string2 + "\"");
    }

    static {
        $assertionsDisabled = DiskLruCache.class.desiredAssertionStatus() ^ true;
        LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,120}");
    }

    public synchronized void initialize() throws IOException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                DiskLruCache diskLruCache = this;
                File file = diskLruCache.journalFileBackup;
                this.fileSystem.rename(file, diskLruCache.journalFile);
            }
        }
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                DiskLruCache diskLruCache = this;
                diskLruCache.readJournal();
                diskLruCache.processJournal();
                diskLruCache.initialized = true;
                return;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "DiskLruCache " + this.directory + " is corrupt: " + iOException.getMessage() + ", removing", iOException);
                try {
                    this.delete();
                    this.closed = false;
                }
                catch (Throwable throwable) {
                    this.closed = false;
                    throw throwable;
                }
            }
        }
        this.rebuildJournal();
        this.initialized = true;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void rebuildJournal() throws IOException {
        block22: {
            var1_1 = this.journalWriter;
            if (var1_1 != null) {
                var1_1.close();
            }
            v0 = this;
            var1_1 = Okio.buffer(v0.fileSystem.sink(this.journalFileTmp));
            v1 = this;
            v2 = var1_1;
            v3 = this;
            v4 = var1_1;
            v5 = v4;
            v4.writeUtf8("libcore.io.DiskLruCache").writeByte(10);
            v5.writeUtf8("1").writeByte(10);
            v6 = v3.appVersion;
            v2.writeDecimalLong(v6).writeByte(10);
            v7 = v1.valueCount;
            var1_1.writeDecimalLong(v7).writeByte(10);
            var1_1.writeByte(10);
            var2_2 = v0.lruEntries.values().iterator();
            block18: while (true) {
                if (!var2_2.hasNext()) break block22;
                var3_3 = var2_2.next();
                if (var3_3.currentEditor == null) break;
                v8 = var1_1;
                v9 = v8;
                v10 = v8;
                v11 = var3_3;
                var1_1.writeUtf8("DIRTY").writeByte(32);
                v9.writeUtf8(v11.key);
                v12 = v10.writeByte(10);
lbl51:
                // 2 sources

                continue block18;
                break;
            }
            try {
                v13 = var1_1;
                v14 = var3_3;
                v15 = var1_1;
                v16 = v15;
                v17 = v15;
                v18 = var3_3;
                var1_1.writeUtf8("CLEAN").writeByte(32);
            }
            catch (Throwable v19) {
                var1_1.close();
                throw v19;
            }
            v16.writeUtf8(v18.key);
            v14.writeLengths(v17);
            v12 = v13.writeByte(10);
            ** continue;
        }
        var1_1.close();
        if (this.fileSystem.exists(this.journalFile)) {
            v20 = this;
            var1_1 = v20.journalFile;
            this.fileSystem.rename((File)var1_1, v20.journalFileBackup);
        }
        v21 = this;
        v22 = this;
        var1_1 = v22.journalFileTmp;
        v21.fileSystem.rename((File)var1_1, v22.journalFile);
        v21.fileSystem.delete(this.journalFileBackup);
        v21.journalWriter = v21.newJournalWriter();
        v21.hasJournalErrors = false;
        v21.mostRecentRebuildFailed = false;
    }

    public synchronized Snapshot get(String string2) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey(string2);
        Object object = diskLruCache.lruEntries.get(string2);
        if (object != null && ((Entry)object).readable) {
            if ((object = ((Entry)object).snapshot()) == null) {
                return null;
            }
            DiskLruCache diskLruCache3 = this;
            ++diskLruCache3.redundantOpCount;
            diskLruCache3.journalWriter.writeUtf8(READ).writeByte(32).writeUtf8(string2).writeByte(10);
            if (diskLruCache3.journalRebuildRequired()) {
                this.executor.execute(this.cleanupRunnable);
            }
            return object;
        }
        return null;
    }

    @Nullable
    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    synchronized Editor edit(String object, long l2) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey((String)object);
        Entry entry = diskLruCache.lruEntries.get(object);
        if (l2 != -1L && (entry == null || entry.sequenceNumber != l2)) {
            return null;
        }
        if (entry != null && entry.currentEditor != null) {
            return null;
        }
        if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) {
            Editor editor;
            DiskLruCache diskLruCache3 = this;
            diskLruCache3.journalWriter.writeUtf8(DIRTY).writeByte(32).writeUtf8((String)object).writeByte(10);
            diskLruCache3.journalWriter.flush();
            if (diskLruCache3.hasJournalErrors) {
                return null;
            }
            if (entry == null) {
                Entry entry2;
                entry = entry2;
                entry2 = new Entry(this, (String)object);
                this.lruEntries.put((String)object, entry);
            }
            object = editor;
            ((Editor)object)(entry);
            entry.currentEditor = object;
            return editor;
        }
        this.executor.execute(this.cleanupRunnable);
        return null;
    }

    public File getDirectory() {
        return this.directory;
    }

    public synchronized long getMaxSize() {
        return this.maxSize;
    }

    public synchronized void setMaxSize(long l2) {
        this.maxSize = l2;
        if (this.initialized) {
            this.executor.execute(this.cleanupRunnable);
        }
    }

    public synchronized long size() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.initialize();
        return diskLruCache.size;
    }

    synchronized void completeEdit(Editor editor, boolean bl) throws IOException {
        Entry entry = editor.entry;
        if (entry.currentEditor == editor) {
            if (bl && !entry.readable) {
                for (int i2 = 0; i2 < this.valueCount; ++i2) {
                    if (editor.written[i2]) {
                        if (this.fileSystem.exists(entry.dirtyFiles[i2])) continue;
                        editor.abort();
                        return;
                    }
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i2);
                }
            }
            for (int i3 = 0; i3 < this.valueCount; ++i3) {
                File file = entry.dirtyFiles[i3];
                if (bl) {
                    long l2;
                    if (!this.fileSystem.exists(file)) continue;
                    File file2 = entry.cleanFiles[i3];
                    this.fileSystem.rename(file, file2);
                    long l3 = entry.lengths[i3];
                    entry.lengths[i3] = l2 = this.fileSystem.size(file2);
                    this.size = this.size - l3 + l2;
                    continue;
                }
                this.fileSystem.delete(file);
            }
            ++this.redundantOpCount;
            entry.currentEditor = null;
            if (entry.readable | bl) {
                DiskLruCache diskLruCache = this;
                entry.readable = true;
                diskLruCache.journalWriter.writeUtf8(CLEAN).writeByte(32);
                diskLruCache.journalWriter.writeUtf8(entry.key);
                entry.writeLengths(diskLruCache.journalWriter);
                this.journalWriter.writeByte(10);
                if (bl) {
                    long l4 = this.nextSequenceNumber;
                    this.nextSequenceNumber = l4 + 1L;
                    entry.sequenceNumber = l4;
                }
            } else {
                DiskLruCache diskLruCache = this;
                diskLruCache.lruEntries.remove(entry.key);
                diskLruCache.journalWriter.writeUtf8(REMOVE).writeByte(32);
                diskLruCache.journalWriter.writeUtf8(entry.key);
                diskLruCache.journalWriter.writeByte(10);
            }
            DiskLruCache diskLruCache = this;
            diskLruCache.journalWriter.flush();
            if (diskLruCache.size > this.maxSize || this.journalRebuildRequired()) {
                this.executor.execute(this.cleanupRunnable);
            }
            return;
        }
        throw new IllegalStateException();
    }

    boolean journalRebuildRequired() {
        int n2 = this.redundantOpCount;
        return n2 >= 2000 && n2 >= this.lruEntries.size();
    }

    public synchronized boolean remove(String object) throws IOException {
        DiskLruCache diskLruCache = this;
        DiskLruCache diskLruCache2 = this;
        diskLruCache2.initialize();
        diskLruCache2.checkNotClosed();
        diskLruCache.validateKey((String)object);
        object = diskLruCache.lruEntries.get(object);
        if (object == null) {
            return false;
        }
        boolean bl = this.removeEntry((Entry)object);
        if (bl && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return bl;
    }

    boolean removeEntry(Entry entry) throws IOException {
        Editor editor = entry.currentEditor;
        if (editor != null) {
            editor.detach();
        }
        for (int i2 = 0; i2 < this.valueCount; ++i2) {
            DiskLruCache diskLruCache = this;
            diskLruCache.fileSystem.delete(entry.cleanFiles[i2]);
            long l2 = diskLruCache.size;
            long[] lArray = entry.lengths;
            this.size = l2 - lArray[i2];
            entry.lengths[i2] = 0L;
        }
        DiskLruCache diskLruCache = this;
        ++diskLruCache.redundantOpCount;
        diskLruCache.journalWriter.writeUtf8(REMOVE).writeByte(32).writeUtf8(entry.key).writeByte(10);
        diskLruCache.lruEntries.remove(entry.key);
        if (diskLruCache.journalRebuildRequired()) {
            this.executor.execute(this.cleanupRunnable);
        }
        return true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        DiskLruCache diskLruCache = this;
        diskLruCache.checkNotClosed();
        diskLruCache.trimToSize();
        diskLruCache.journalWriter.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.initialized && !this.closed) {
            Entry[] entryArray = this.lruEntries.values().toArray(new Entry[this.lruEntries.size()]);
            int n2 = entryArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Editor editor = entryArray[i2].currentEditor;
                if (editor == null) continue;
                editor.abort();
            }
            DiskLruCache diskLruCache = this;
            diskLruCache.trimToSize();
            diskLruCache.journalWriter.close();
            diskLruCache.journalWriter = null;
            diskLruCache.closed = true;
            return;
        }
        this.closed = true;
    }

    void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            DiskLruCache diskLruCache = this;
            diskLruCache.removeEntry(diskLruCache.lruEntries.values().iterator().next());
        }
        this.mostRecentTrimFailed = false;
    }

    public void delete() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.close();
        diskLruCache.fileSystem.deleteContents(this.directory);
    }

    public synchronized void evictAll() throws IOException {
        DiskLruCache diskLruCache = this;
        diskLruCache.initialize();
        Entry[] entryArray = diskLruCache.lruEntries.values().toArray(new Entry[this.lruEntries.size()]);
        int n2 = entryArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.removeEntry(entryArray[i2]);
        }
        this.mostRecentTrimFailed = false;
    }

    public synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(){
            final Iterator<Entry> delegate;
            Snapshot nextSnapshot;
            Snapshot removeSnapshot;
            {
                this.delegate = new ArrayList<Entry>(DiskLruCache.this.lruEntries.values()).iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                3 v0 = this;
                DiskLruCache diskLruCache = v0.DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (v0.DiskLruCache.this.closed) {
                        return false;
                    }
                    while (this.delegate.hasNext()) {
                        Object object = this.delegate.next();
                        if (!((Entry)object).readable || (object = ((Entry)object).snapshot()) == null) continue;
                        this.nextSnapshot = object;
                        return true;
                    }
                    return false;
                }
            }

            @Override
            public Snapshot next() {
                if (this.hasNext()) {
                    Snapshot snapshot = this.nextSnapshot;
                    3 v0 = this;
                    v0.removeSnapshot = snapshot;
                    v0.nextSnapshot = null;
                    return snapshot;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                block3: {
                    Snapshot snapshot = this.removeSnapshot;
                    if (snapshot == null) break block3;
                    try {
                        3 v0 = this;
                        3 v1 = v0;
                        v0.DiskLruCache.this.remove(snapshot.key);
                    }
                    catch (Throwable throwable) {
                        this.removeSnapshot = null;
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        this.removeSnapshot = null;
                    }
                    v1.removeSnapshot = null;
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    private final class Entry {
        final String key;
        final long[] lengths;
        final File[] cleanFiles;
        final File[] dirtyFiles;
        boolean readable;
        Editor currentEditor;
        long sequenceNumber;
        final /* synthetic */ DiskLruCache this$0;

        Entry(DiskLruCache diskLruCache, String charSequence) {
            Entry entry = this;
            this.this$0 = diskLruCache;
            this.key = charSequence;
            int n2 = diskLruCache.valueCount;
            entry.lengths = new long[n2];
            entry.cleanFiles = new File[n2];
            entry.dirtyFiles = new File[n2];
            charSequence = new StringBuilder((String)charSequence).append('.');
            n2 = ((StringBuilder)charSequence).length();
            for (int i2 = 0; i2 < diskLruCache.valueCount; ++i2) {
                File file;
                File file2;
                ((StringBuilder)charSequence).append(i2);
                File file3 = file2;
                File file4 = diskLruCache.directory;
                file2 = new File(file4, ((StringBuilder)charSequence).toString());
                this.cleanFiles[i2] = file3;
                ((StringBuilder)charSequence).append(".tmp");
                file3 = file;
                file4 = diskLruCache.directory;
                file = new File(file4, ((StringBuilder)charSequence).toString());
                this.dirtyFiles[i2] = file3;
                ((StringBuilder)charSequence).setLength(n2);
            }
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != this.this$0.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n2 = 0;
            try {
                while (true) {
                    if (n2 >= stringArray.length) {
                        return;
                    }
                    this.lengths[n2] = Long.parseLong(stringArray[n2]);
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        void writeLengths(BufferedSink bufferedSink) throws IOException {
            Object object = ((Entry)object).lengths;
            int n2 = ((Entry)object).lengths.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2 = object[i2];
                bufferedSink.writeByte(32).writeDecimalLong((long)object2);
            }
        }

        Snapshot snapshot() {
            block11: {
                String string2;
                Entry entry;
                DiskLruCache diskLruCache;
                Snapshot snapshot;
                Snapshot snapshot2;
                DiskLruCache diskLruCache2;
                if (!Thread.holdsLock(this.this$0)) break block11;
                Entry entry2 = this;
                Source[] sourceArray = new Source[entry2.this$0.valueCount];
                long[] lArray = (long[])entry2.lengths.clone();
                int n2 = 0;
                while (true) {
                    int n3 = n2;
                    diskLruCache2 = this.this$0;
                    if (n3 >= diskLruCache2.valueCount) break;
                    sourceArray[n2] = diskLruCache2.fileSystem.source(this.cleanFiles[n2]);
                    ++n2;
                    continue;
                    break;
                }
                try {
                    Snapshot snapshot3;
                    snapshot2 = snapshot3;
                    snapshot = snapshot3;
                    diskLruCache = diskLruCache2;
                    Entry entry3 = this;
                    entry = entry3;
                    string2 = entry3.key;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DiskLruCache diskLruCache3;
                    int n4 = 0;
                    while (true) {
                        diskLruCache3 = this.this$0;
                        if (n4 >= diskLruCache3.valueCount || sourceArray[n4] == null) break;
                        Util.closeQuietly(sourceArray[n4]);
                        ++n4;
                    }
                    try {
                        diskLruCache3.removeEntry(this);
                    }
                    catch (IOException iOException) {}
                    return null;
                }
                long l2 = entry.sequenceNumber;
                snapshot2(string2, l2, sourceArray, lArray);
                return snapshot;
            }
            throw new AssertionError();
        }
    }

    public final class Editor {
        final Entry entry;
        final boolean[] written;
        private boolean done;

        Editor(Entry entry) {
            this.entry = entry;
            DiskLruCache.this = entry.readable ? null : (Object)new boolean[((DiskLruCache)DiskLruCache.this).valueCount];
            this.written = (boolean[])DiskLruCache.this;
        }

        void detach() {
            if (this.entry.currentEditor == this) {
                int n2 = 0;
                while (true) {
                    DiskLruCache diskLruCache = DiskLruCache.this;
                    if (n2 >= diskLruCache.valueCount) break;
                    try {
                        diskLruCache.fileSystem.delete(this.entry.dirtyFiles[n2]);
                    }
                    catch (IOException iOException) {}
                    ++n2;
                }
                this.entry.currentEditor = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Source newSource(int n2) {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                block10: {
                    if (editor.done) throw new IllegalStateException();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    Entry entry = this.entry;
                    if (!entry.readable) break block10;
                    if (entry.currentEditor != this) break block10;
                    try {
                        return DiskLruCache.this.fileSystem.source(entry.cleanFiles[n2]);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Sink newSink(int n2) {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            // MONITORENTER : diskLruCache
            if (editor.done) throw new IllegalStateException();
            Entry entry = this.entry;
            if (entry.currentEditor != this) {
                // MONITOREXIT : diskLruCache
                return Okio.blackhole();
            }
            if (!entry.readable) {
                this.written[n2] = true;
            }
            Object object = entry.dirtyFiles[n2];
            object = DiskLruCache.this.fileSystem.sink((File)object);
            // MONITOREXIT : diskLruCache
            return new FaultHidingSink((Sink)object){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onException(IOException object) {
                    object = DiskLruCache.this;
                    synchronized (object) {
                        Editor.this.detach();
                        return;
                    }
                }
            };
            {
                catch (Throwable throwable) {
                    // MONITOREXIT : diskLruCache
                    throw throwable;
                }
            }
            {
                catch (FileNotFoundException fileNotFoundException) {
                    // MONITOREXIT : diskLruCache
                    return Okio.blackhole();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void commit() throws IOException {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!editor.done) {
                    if (this.entry.currentEditor == this) {
                        DiskLruCache.this.completeEdit(this, true);
                    }
                    this.done = true;
                    return;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void abort() throws IOException {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                if (!editor.done) {
                    if (this.entry.currentEditor == this) {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    this.done = true;
                    return;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abortUnlessCommitted() {
            Editor editor = this;
            DiskLruCache diskLruCache = editor.DiskLruCache.this;
            synchronized (diskLruCache) {
                block7: {
                    if (editor.done) break block7;
                    if (this.entry.currentEditor != this) break block7;
                    try {
                        DiskLruCache.this.completeEdit(this, false);
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final Source[] sources;
        private final long[] lengths;

        Snapshot(String string2, long l2, Source[] sourceArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l2;
            this.sources = sourceArray;
            this.lengths = lArray;
        }

        public String key() {
            return this.key;
        }

        @Nullable
        public Editor edit() throws IOException {
            Snapshot snapshot = string2;
            String string2 = snapshot.key;
            long l2 = snapshot.sequenceNumber;
            return ((Snapshot)((Object)string2)).DiskLruCache.this.edit(string2, l2);
        }

        public Source getSource(int n2) {
            return this.sources[n2];
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }

        @Override
        public void close() {
            Source[] sourceArray = sourceArray.sources;
            int n2 = sourceArray.sources.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Util.closeQuietly(sourceArray[i2]);
            }
        }
    }
}

