/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Challenge;
import dc.squareup.okhttp3.Cookie;
import dc.squareup.okhttp3.CookieJar;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class HttpHeaders {
    private static final ByteString QUOTED_STRING_DELIMITERS = ByteString.encodeUtf8("\"\\");
    private static final ByteString TOKEN_DELIMITERS = ByteString.encodeUtf8("\t ,=");

    private HttpHeaders() {
    }

    public static long contentLength(Response response) {
        return HttpHeaders.contentLength(response.headers());
    }

    public static long contentLength(Headers headers) {
        return HttpHeaders.stringToLong(headers.get("Content-Length"));
    }

    private static long stringToLong(String string2) {
        if (string2 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean varyMatches(Response object, Headers headers, Request request) {
        for (String string2 : HttpHeaders.varyFields((Response)object)) {
            if (Util.equal(headers.values(string2), request.headers(string2))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasVaryAll(Response response) {
        return HttpHeaders.hasVaryAll(response.headers());
    }

    public static boolean hasVaryAll(Headers headers) {
        return HttpHeaders.varyFields(headers).contains("*");
    }

    private static Set<String> varyFields(Response response) {
        return HttpHeaders.varyFields(response.headers());
    }

    public static Set<String> varyFields(Headers headers) {
        TreeSet<String> treeSet = Collections.emptySet();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!"Vary".equalsIgnoreCase(headers.name(i2))) continue;
            String[] stringArray = headers.value(i2);
            if (treeSet.isEmpty()) {
                TreeSet<String> treeSet2;
                treeSet = treeSet2;
                treeSet2 = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            stringArray = stringArray.split(",");
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                treeSet.add(stringArray[i3].trim());
            }
        }
        return treeSet;
    }

    public static Headers varyHeaders(Response response) {
        return HttpHeaders.varyHeaders(response.networkResponse().request().headers(), response.headers());
    }

    public static Headers varyHeaders(Headers headers, Headers object) {
        Headers.Builder builder;
        if ((object = HttpHeaders.varyFields((Headers)object)).isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder builder2 = builder;
        builder = new Headers.Builder();
        int n2 = headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = headers.name(i2);
            if (!object.contains(string2)) continue;
            builder2.add(string2, headers.value(i2));
        }
        return builder2.build();
    }

    public static List<Challenge> parseChallenges(Headers headers, String string2) {
        ArrayList<Challenge> arrayList;
        ArrayList<Challenge> arrayList2 = arrayList;
        arrayList = new ArrayList<Challenge>();
        for (int i2 = 0; i2 < headers.size(); ++i2) {
            Buffer buffer;
            if (!string2.equalsIgnoreCase(headers.name(i2))) continue;
            Buffer buffer2 = buffer;
            buffer2();
            HttpHeaders.parseChallengeHeader(arrayList2, buffer.writeUtf8(headers.value(i2)));
        }
        return arrayList2;
    }

    private static void parseChallengeHeader(List<Challenge> object, Buffer buffer) {
        String string2 = null;
        block0: while (true) {
            LinkedHashMap<String, String> linkedHashMap;
            if (string2 == null) {
                Buffer buffer2 = buffer;
                HttpHeaders.skipWhitespaceAndCommas(buffer2);
                string2 = HttpHeaders.readToken(buffer2);
                if (string2 == null) {
                    return;
                }
            }
            Buffer buffer3 = buffer;
            int n2 = HttpHeaders.skipWhitespaceAndCommas(buffer3);
            String string3 = HttpHeaders.readToken(buffer3);
            if (string3 == null) {
                Challenge challenge;
                if (!buffer.exhausted()) {
                    return;
                }
                List<Challenge> list = object;
                object = challenge;
                challenge = new Challenge(string2, Collections.emptyMap());
                list.add((Challenge)object);
                return;
            }
            int n3 = n2;
            Buffer buffer4 = buffer;
            n2 = HttpHeaders.skipAll(buffer4, (byte)61);
            int n4 = HttpHeaders.skipWhitespaceAndCommas(buffer4);
            if (n3 == 0 && (n4 != 0 || buffer.exhausted())) {
                object.add(new Challenge(string2, Collections.singletonMap(null, string3 + HttpHeaders.repeat('=', n2))));
                string2 = null;
                continue;
            }
            LinkedHashMap<String, String> linkedHashMap2 = linkedHashMap;
            linkedHashMap = new LinkedHashMap<String, String>();
            n4 = n2 + HttpHeaders.skipAll(buffer, (byte)61);
            do {
                block15: {
                    Challenge challenge;
                    block14: {
                        block13: {
                            if (string3 != null) break block13;
                            Buffer buffer5 = buffer;
                            string3 = HttpHeaders.readToken(buffer5);
                            if (HttpHeaders.skipWhitespaceAndCommas(buffer5)) break block14;
                            n4 = HttpHeaders.skipAll(buffer, (byte)61);
                        }
                        if (n4 != 0) break block15;
                    }
                    Challenge challenge2 = challenge;
                    challenge = new Challenge(string2, linkedHashMap2);
                    object.add(challenge2);
                    string2 = string3;
                    continue block0;
                }
                if (n4 > 1) {
                    return;
                }
                if (HttpHeaders.skipWhitespaceAndCommas(buffer)) {
                    return;
                }
                String string4 = !buffer.exhausted() && buffer.getByte(0L) == 34 ? HttpHeaders.readQuotedString(buffer) : HttpHeaders.readToken(buffer);
                if (string4 == null) {
                    return;
                }
                string3 = null;
                if (linkedHashMap2.put(string3, string4) == null) continue;
                return;
            } while (HttpHeaders.skipWhitespaceAndCommas(buffer) || buffer.exhausted());
            break;
        }
    }

    private static boolean skipWhitespaceAndCommas(Buffer buffer) {
        boolean bl = false;
        while (!buffer.exhausted()) {
            byte by = buffer.getByte(0L);
            if (by == 44) {
                buffer.readByte();
                bl = true;
                continue;
            }
            if (by != 32 && by != 9) break;
            buffer.readByte();
        }
        return bl;
    }

    private static int skipAll(Buffer buffer, byte by) {
        int n2 = 0;
        while (!buffer.exhausted() && buffer.getByte(0L) == by) {
            ++n2;
            buffer.readByte();
        }
        return n2;
    }

    private static String readQuotedString(Buffer buffer) {
        if (buffer.readByte() == 34) {
            Buffer buffer2;
            Buffer buffer3 = buffer2;
            buffer2 = new Buffer();
            while (true) {
                long l2;
                if ((l2 = buffer.indexOfElement(QUOTED_STRING_DELIMITERS)) == -1L) {
                    return null;
                }
                if (buffer.getByte(l2) == 34) {
                    buffer3.write(buffer, l2);
                    buffer.readByte();
                    return buffer3.readUtf8();
                }
                if (buffer.size() == l2 + 1L) {
                    return null;
                }
                buffer3.write(buffer, l2);
                buffer.readByte();
                buffer3.write(buffer, 1L);
            }
        }
        throw new IllegalArgumentException();
    }

    private static String readToken(Buffer object) {
        long l2;
        block6: {
            try {
                l2 = ((Buffer)object).indexOfElement(TOKEN_DELIMITERS);
                if (l2 != -1L) break block6;
            }
            catch (EOFException eOFException) {
                throw new AssertionError();
            }
            l2 = ((Buffer)object).size();
        }
        if (l2 != 0L) {
            object = ((Buffer)object).readUtf8(l2);
        } else {
            object = null;
        }
        return object;
    }

    private static String repeat(char c2, int n2) {
        char[] cArray = new char[n2];
        Arrays.fill(cArray, c2);
        return new String(cArray);
    }

    public static void receiveHeaders(CookieJar cookieJar, HttpUrl httpUrl, Headers object) {
        if (cookieJar == CookieJar.NO_COOKIES) {
            return;
        }
        if ((object = Cookie.parseAll(httpUrl, (Headers)object)).isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse(httpUrl, (List<Cookie>)object);
    }

    public static boolean hasBody(Response response) {
        if (response.request().method().equals("HEAD")) {
            return false;
        }
        int n2 = response.code();
        if ((n2 < 100 || n2 >= 200) && n2 != 204 && n2 != 304) {
            return true;
        }
        return HttpHeaders.contentLength(response) != -1L || "chunked".equalsIgnoreCase(response.header("Transfer-Encoding"));
        {
        }
    }

    public static int skipUntil(String string2, int n2, String string3) {
        while (n2 < string2.length() && string3.indexOf(string2.charAt(n2)) == -1) {
            ++n2;
        }
        return n2;
    }

    public static int skipWhitespace(String string2, int n2) {
        char c2;
        while (n2 < string2.length() && ((c2 = string2.charAt(n2)) == ' ' || c2 == '\t')) {
            ++n2;
        }
        return n2;
    }

    public static int parseSeconds(String string2, int n2) {
        long l2;
        block3: {
            try {
                l2 = Long.parseLong(string2);
                if (l2 > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                if (l2 >= 0L) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }
        return (int)l2;
    }
}

