/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.IOException;
import java.util.zip.Deflater;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this(Okio.buffer(sink), deflater);
    }

    DeflaterSink(BufferedSink bufferedSink, Deflater deflater) {
        if (bufferedSink != null) {
            if (deflater != null) {
                DeflaterSink deflaterSink = this;
                deflaterSink.sink = bufferedSink;
                deflaterSink.deflater = deflater;
                return;
            }
            throw new IllegalArgumentException("inflater == null");
        }
        throw new IllegalArgumentException("source == null");
    }

    private void deflate(boolean bl) throws IOException {
        Segment segment;
        Buffer buffer = this.sink.buffer();
        while (true) {
            int n2;
            int n3;
            segment = buffer.writableSegment(1);
            if (bl) {
                Segment segment2 = segment;
                byte[] byArray = segment2.data;
                n3 = segment2.limit;
                n2 = this.deflater.deflate(byArray, n3, 8192 - n3, 2);
            } else {
                Segment segment3 = segment;
                byte[] byArray = segment3.data;
                n3 = segment3.limit;
                n2 = this.deflater.deflate(byArray, n3, 8192 - n3);
            }
            if (n2 > 0) {
                segment.limit += n2;
                buffer.size += (long)n2;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        if (segment.pos == segment.limit) {
            buffer.head = segment.pop();
            SegmentPool.recycle(segment);
        }
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        while (l2 > 0L) {
            DeflaterSink deflaterSink = this;
            Segment segment = buffer.head;
            int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
            Segment segment2 = segment;
            byte[] byArray = segment2.data;
            deflaterSink.deflater.setInput(byArray, segment2.pos, n2);
            deflaterSink.deflate(false);
            long l3 = n2;
            buffer.size -= l3;
            segment.pos = n2 = segment.pos + n2;
            if (n2 == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l2 -= l3;
        }
    }

    @Override
    public void flush() throws IOException {
        DeflaterSink deflaterSink = this;
        deflaterSink.deflate(true);
        deflaterSink.sink.flush();
    }

    void finishDeflate() throws IOException {
        DeflaterSink deflaterSink = this;
        deflaterSink.deflater.finish();
        deflaterSink.deflate(false);
    }

    @Override
    public void close() throws IOException {
        Throwable throwable;
        block9: {
            Throwable throwable2;
            block8: {
                if (this.closed) {
                    return;
                }
                throwable = null;
                try {
                    this.finishDeflate();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) break block8;
                }
                throwable2 = throwable;
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) break block9;
            }
            throwable = throwable2;
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

