/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCTWDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCTWSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCTWProber
extends CharsetProber {
    private static final SMModel smModel = new EUCTWSMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private EUCTWDistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public EUCTWProber() {
        EUCTWProber eUCTWProber = this;
        eUCTWProber.codingSM = new CodingStateMachine(smModel);
        eUCTWProber.distributionAnalyzer = new EUCTWDistributionAnalysis();
        eUCTWProber.lastChar = new byte[2];
        eUCTWProber.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_TW;
    }

    @Override
    public float getConfidence() {
        return this.distributionAnalyzer.getConfidence();
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = this.codingSM.nextState(byArray[i2]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            n4 = this.codingSM.getCurrentCharLen();
            if (i2 == n2) {
                EUCTWProber eUCTWProber = this;
                byte[] byArray2 = eUCTWProber.lastChar;
                eUCTWProber.lastChar[1] = byArray[n2];
                eUCTWProber.distributionAnalyzer.handleOneChar(byArray2, 0, n4);
                continue;
            }
            this.distributionAnalyzer.handleOneChar(byArray, i2 - 1, n4);
        }
        EUCTWProber eUCTWProber = this;
        eUCTWProber.lastChar[0] = byArray[n3 - 1];
        if (eUCTWProber.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        EUCTWProber eUCTWProber = this;
        eUCTWProber.codingSM.reset();
        eUCTWProber.state = CharsetProber.ProbingState.DETECTING;
        eUCTWProber.distributionAnalyzer.reset();
        Arrays.fill(eUCTWProber.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

