/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code39Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    private static void toIntArray(int n2, int[] nArray) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n3 = (n2 & 1 << 8 - i2) == 0 ? 1 : 2;
            nArray[i2] = n3;
        }
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_39) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n2 = string2.length();
        if (n2 <= 80) {
            int n3;
            int n4;
            int n5 = 9;
            int[] nArray = new int[9];
            int n6 = n2 + 25;
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(n4));
                if (n3 >= 0) {
                    Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n3], nArray);
                    for (n3 = 0; n3 < n5; ++n3) {
                        n6 += nArray[n3];
                    }
                    continue;
                }
                throw new IllegalArgumentException("Bad contents: " + string2);
            }
            boolean[] blArray = new boolean[n6];
            Code39Writer.toIntArray(Code39Reader.ASTERISK_ENCODING, nArray);
            int n7 = OneDimensionalCodeWriter.appendPattern(blArray, 0, nArray, true);
            int[] nArray2 = new int[1];
            int[] nArray3 = nArray2;
            nArray2[0] = 1;
            n4 = n7 + OneDimensionalCodeWriter.appendPattern(blArray, n7, nArray3, false);
            for (n3 = 0; n3 < n2; ++n3) {
                Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(n3))], nArray);
                int n8 = n4 + OneDimensionalCodeWriter.appendPattern(blArray, n4, nArray, true);
                n4 = n8 + OneDimensionalCodeWriter.appendPattern(blArray, n8, nArray3, false);
            }
            Code39Writer.toIntArray(Code39Reader.ASTERISK_ENCODING, nArray);
            OneDimensionalCodeWriter.appendPattern(blArray, n4, nArray, true);
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
    }
}

