/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.EAN13Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import java.util.Map;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.EAN_13) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode EAN_13, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 13) {
            block7: {
                if (!UPCEANReader.checkStandardUPCEANChecksum(string2)) break block7;
                int n2 = EAN13Reader.FIRST_DIGIT_ENCODINGS[Integer.parseInt(string2.substring(0, 1))];
                boolean[] blArray = new boolean[95];
                int n3 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true) + 0;
                int n4 = 1;
                while (n4 <= 6) {
                    int n5 = n4;
                    int n6 = n5 + 1;
                    int n7 = Integer.parseInt(string2.substring(n5, n6));
                    if ((n2 >> 6 - n4 & 1) == 1) {
                        n7 += 10;
                    }
                    n3 += OneDimensionalCodeWriter.appendPattern(blArray, n3, UPCEANReader.L_AND_G_PATTERNS[n7], false);
                    n4 = n6;
                }
                n2 = n3 + OneDimensionalCodeWriter.appendPattern(blArray, n3, UPCEANReader.MIDDLE_PATTERN, false);
                n3 = 7;
                while (n3 <= 12) {
                    n2 += OneDimensionalCodeWriter.appendPattern(blArray, n2, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n3++, n3))], true);
                }
                OneDimensionalCodeWriter.appendPattern(blArray, n2, UPCEANReader.START_END_PATTERN, true);
                return blArray;
            }
            try {
                throw new IllegalArgumentException("Contents do not pass checksum");
            }
            catch (FormatException formatException) {
                throw new IllegalArgumentException("Illegal contents");
            }
        }
        throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string2.length());
    }
}

