/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    static int getDecodedValue(int[] nArray) {
        int n2 = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(nArray));
        if (n2 != -1) {
            return n2;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    private static int[] sampleBitCounts(int[] nArray) {
        float f2 = PDF417Common.getBitCountSum(nArray);
        int[] nArray2 = new int[8];
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 17; ++i2) {
            float f3 = f2 / 34.0f + (float)i2 * f2 / 17.0f;
            if ((float)(n3 + nArray[n2]) <= f3) {
                n3 += nArray[n2];
                ++n2;
            }
            nArray2[n2] = nArray2[n2] + 1;
        }
        return nArray2;
    }

    private static int getDecodedCodewordValue(int[] nArray) {
        int n2 = PDF417CodewordDecoder.getBitValue(nArray);
        if (PDF417Common.getCodeword(n2) == -1) {
            n2 = -1;
        }
        return n2;
    }

    private static int getBitValue(int[] nArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            for (int i3 = 0; i3 < nArray[i2]; ++i3) {
                l2 <<= 1;
                long l3 = i2 % 2 == 0 ? 1 : 0;
                l2 |= l3;
            }
        }
        return (int)l2;
    }

    private static int getClosestDecodedValue(int[] nArray) {
        int n2 = PDF417Common.getBitCountSum(nArray);
        int n3 = 8;
        float[] fArray = new float[8];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray[i2] = (float)nArray[i2] / (float)n2;
        }
        float f2 = Float.MAX_VALUE;
        n2 = -1;
        n3 = 0;
        while (true) {
            float[][] fArray2 = RATIOS_TABLE;
            if (n3 >= RATIOS_TABLE.length) break;
            float f3 = 0.0f;
            float[] fArray3 = fArray2[n3];
            for (int i3 = 0; i3 < 8; ++i3) {
                float f4;
                float f5 = fArray3[i3] - fArray[i3];
                f3 += f5 * f5;
                if (f4 >= f2) break;
            }
            if (f3 < f2) {
                n2 = PDF417Common.SYMBOL_TABLE[n3];
            } else {
                f3 = f2;
            }
            ++n3;
            f2 = f3;
        }
        return n2;
    }

    static {
        int n2 = 0;
        while (true) {
            int[] nArray = PDF417Common.SYMBOL_TABLE;
            if (n2 >= PDF417Common.SYMBOL_TABLE.length) break;
            int n3 = nArray[n2];
            int n4 = n3 & 1;
            for (int i2 = 0; i2 < 8; ++i2) {
                int n5;
                float f2 = 0.0f;
                while ((n5 = n3 & 1) == n4) {
                    f2 += 1.0f;
                    n3 >>= 1;
                }
                n4 = 8 - i2 - 1;
                PDF417CodewordDecoder.RATIOS_TABLE[n2][n4] = f2 / 17.0f;
                n4 = n5;
            }
            ++n2;
        }
    }
}

