/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder.ec;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.pdf417.decoder.ec.ModulusGF;
import com.dcloud.zxing2.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int n2) throws ChecksumException {
        if (modulusPoly.getDegree() >= modulusPoly2.getDegree()) {
            ModulusPoly modulusPoly3 = modulusPoly;
            modulusPoly = modulusPoly2;
            modulusPoly2 = modulusPoly3;
        }
        ErrorCorrection errorCorrection = this;
        ModulusPoly modulusPoly4 = errorCorrection.field.getZero();
        ModulusPoly modulusPoly5 = errorCorrection.field.getOne();
        while (modulusPoly.getDegree() >= n2 / 2) {
            if (!modulusPoly.isZero()) {
                ModulusPoly modulusPoly6 = modulusPoly;
                ModulusPoly modulusPoly7 = this.field.getZero();
                int n3 = modulusPoly6.getCoefficient(modulusPoly6.getDegree());
                n3 = this.field.inverse(n3);
                while (modulusPoly2.getDegree() >= modulusPoly.getDegree() && !modulusPoly2.isZero()) {
                    ErrorCorrection errorCorrection2 = this;
                    int n4 = modulusPoly2.getDegree() - modulusPoly.getDegree();
                    ModulusPoly modulusPoly8 = modulusPoly2;
                    int n5 = errorCorrection2.field.multiply(modulusPoly8.getCoefficient(modulusPoly8.getDegree()), n3);
                    ModulusPoly modulusPoly9 = modulusPoly7.add(errorCorrection2.field.buildMonomial(n4, n5));
                    modulusPoly2 = modulusPoly2.subtract(modulusPoly.multiplyByMonomial(n4, n5));
                    modulusPoly7 = modulusPoly9;
                }
                modulusPoly4 = modulusPoly7.multiply(modulusPoly5).subtract(modulusPoly4).negative();
                ModulusPoly modulusPoly10 = modulusPoly2;
                ModulusPoly modulusPoly11 = modulusPoly4;
                modulusPoly4 = modulusPoly5;
                modulusPoly2 = modulusPoly;
                modulusPoly5 = modulusPoly11;
                modulusPoly = modulusPoly10;
                continue;
            }
            throw ChecksumException.getChecksumInstance();
        }
        int n6 = modulusPoly5.getCoefficient(0);
        if (n6 != 0) {
            ModulusPoly modulusPoly12 = modulusPoly;
            int n7 = this.field.inverse(n6);
            modulusPoly = modulusPoly5.multiply(n7);
            ModulusPoly modulusPoly13 = modulusPoly12.multiply(n7);
            return new ModulusPoly[]{modulusPoly, modulusPoly13};
        }
        throw ChecksumException.getChecksumInstance();
    }

    private int[] findErrorLocations(ModulusPoly modulusPoly) throws ChecksumException {
        int n2 = modulusPoly.getDegree();
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && n3 < n2; ++i2) {
            if (modulusPoly.evaluateAt(i2) != 0) continue;
            nArray[n3] = this.field.inverse(i2);
            ++n3;
        }
        if (n3 == n2) {
            return nArray;
        }
        throw ChecksumException.getChecksumInstance();
    }

    private int[] findErrorMagnitudes(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int[] nArray) {
        ModulusPoly modulusPoly3;
        int n2;
        int n3 = modulusPoly2.getDegree();
        int[] nArray2 = new int[n3];
        for (n2 = 1; n2 <= n3; ++n2) {
            nArray2[n3 - n2] = this.field.multiply(n2, modulusPoly2.getCoefficient(n2));
        }
        modulusPoly2 = modulusPoly3;
        modulusPoly3 = new ModulusPoly(this.field, nArray2);
        n3 = nArray.length;
        nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            ErrorCorrection errorCorrection = this;
            int n4 = errorCorrection.field.inverse(nArray[n2]);
            int n5 = errorCorrection.field.subtract(0, modulusPoly.evaluateAt(n4));
            n4 = errorCorrection.field.inverse(modulusPoly2.evaluateAt(n4));
            nArray2[n2] = errorCorrection.field.multiply(n5, n4);
        }
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public int decode(int[] nArray, int n2, int[] object) throws ChecksumException {
        void var3_8;
        ModulusPoly modulusPoly;
        ModulusPoly modulusPoly2;
        Object object2 = modulusPoly2;
        modulusPoly2 = new ModulusPoly(this.field, nArray);
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i2 = n2; i2 > 0; --i2) {
            int n4;
            nArray2[n2 - i2] = n4 = ((ModulusPoly)object2).evaluateAt(this.field.exp(i2));
            if (n4 == 0) continue;
            n3 = 1;
        }
        if (n3 == 0) {
            return 0;
        }
        object2 = this.field.getOne();
        if (object != null) {
            for (Object object3 : object) {
                object3 = this.field.exp(nArray.length - 1 - object3);
                ModulusGF modulusGF = this.field;
                int[] nArray3 = new int[2];
                int[] nArray4 = nArray3;
                nArray3[0] = modulusGF.subtract(0, (int)object3);
                nArray3[1] = 1;
                object2 = ((ModulusPoly)object2).multiply(new ModulusPoly(modulusGF, nArray4));
            }
        }
        ErrorCorrection errorCorrection = this;
        ModulusPoly i3 = modulusPoly;
        modulusPoly = new ModulusPoly(this.field, nArray2);
        ModulusPoly[] modulusPolyArray = errorCorrection.runEuclideanAlgorithm(errorCorrection.field.buildMonomial(n2, 1), i3, n2);
        Object object3 = modulusPolyArray[0];
        ModulusPoly modulusPoly3 = modulusPolyArray[1];
        object2 = errorCorrection.findErrorLocations((ModulusPoly)object3);
        object3 = errorCorrection.findErrorMagnitudes(modulusPoly3, (ModulusPoly)object3, (int[])object2);
        boolean bl = false;
        while (var3_8 < ((Object)object2).length) {
            int n5 = nArray.length - 1 - this.field.log((int)object2[var3_8]);
            if (n5 >= 0) {
                int n6 = n5;
                n5 = nArray[n5];
                nArray[n6] = this.field.subtract(n5, (int)object3[var3_8]);
                ++var3_8;
                continue;
            }
            throw ChecksumException.getChecksumInstance();
        }
        return ((Object)object2).length;
    }
}

