/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.util.DisplayMetrics;
import com.nostra13.dcloudimageloader.cache.disc.DiscCacheAware;
import com.nostra13.dcloudimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.dcloudimageloader.cache.memory.impl.FuzzyKeyMemoryCache;
import com.nostra13.dcloudimageloader.core.DefaultConfigurationFactory;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.assist.MemoryCacheUtil;
import com.nostra13.dcloudimageloader.core.assist.QueueProcessingType;
import com.nostra13.dcloudimageloader.core.decode.ImageDecoder;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.nostra13.dcloudimageloader.core.download.NetworkDeniedImageDownloader;
import com.nostra13.dcloudimageloader.core.download.SlowNetworkImageDownloader;
import com.nostra13.dcloudimageloader.core.process.BitmapProcessor;
import com.nostra13.dcloudimageloader.utils.L;
import com.nostra13.dcloudimageloader.utils.StorageUtils;
import java.util.concurrent.Executor;

public final class ImageLoaderConfiguration {
    final Resources resources;
    final int maxImageWidthForMemoryCache;
    final int maxImageHeightForMemoryCache;
    final int maxImageWidthForDiscCache;
    final int maxImageHeightForDiscCache;
    final Bitmap.CompressFormat imageCompressFormatForDiscCache;
    final int imageQualityForDiscCache;
    final BitmapProcessor processorForDiscCache;
    final Executor taskExecutor;
    final Executor taskExecutorForCachedImages;
    final boolean customExecutor;
    final boolean customExecutorForCachedImages;
    final int threadPoolSize;
    final int threadPriority;
    final QueueProcessingType tasksProcessingType;
    final MemoryCacheAware memoryCache;
    final DiscCacheAware discCache;
    final ImageDownloader downloader;
    final ImageDecoder decoder;
    final DisplayImageOptions defaultDisplayImageOptions;
    final boolean writeLogs;
    final DiscCacheAware reserveDiscCache;
    final ImageDownloader networkDeniedDownloader;
    final ImageDownloader slowNetworkDownloader;

    private ImageLoaderConfiguration(Builder builder) {
        ImageLoaderConfiguration imageLoaderConfiguration = imageDownloader;
        ImageLoaderConfiguration imageLoaderConfiguration2 = imageDownloader;
        ImageLoaderConfiguration imageLoaderConfiguration3 = imageDownloader;
        ImageLoaderConfiguration imageLoaderConfiguration4 = imageDownloader;
        ImageLoaderConfiguration imageLoaderConfiguration5 = imageDownloader;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).resources = builder.context.getResources();
        ((ImageLoaderConfiguration)((Object)imageDownloader)).maxImageWidthForMemoryCache = builder.maxImageWidthForMemoryCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).maxImageHeightForMemoryCache = builder.maxImageHeightForMemoryCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).maxImageWidthForDiscCache = builder.maxImageWidthForDiscCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).maxImageHeightForDiscCache = builder.maxImageHeightForDiscCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).imageCompressFormatForDiscCache = builder.imageCompressFormatForDiscCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).imageQualityForDiscCache = builder.imageQualityForDiscCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).processorForDiscCache = builder.processorForDiscCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).taskExecutor = builder.taskExecutor;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).taskExecutorForCachedImages = builder.taskExecutorForCachedImages;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).threadPoolSize = builder.threadPoolSize;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).threadPriority = builder.threadPriority;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).tasksProcessingType = builder.tasksProcessingType;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).discCache = builder.discCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).memoryCache = builder.memoryCache;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).defaultDisplayImageOptions = builder.defaultDisplayImageOptions;
        ((ImageLoaderConfiguration)((Object)imageDownloader)).writeLogs = builder.writeLogs;
        ImageDownloader imageDownloader = builder.downloader;
        imageLoaderConfiguration5.downloader = imageDownloader;
        imageLoaderConfiguration4.decoder = builder.decoder;
        imageLoaderConfiguration3.customExecutor = builder.customExecutor;
        imageLoaderConfiguration2.customExecutorForCachedImages = builder.customExecutorForCachedImages;
        imageLoaderConfiguration2.networkDeniedDownloader = new NetworkDeniedImageDownloader(imageDownloader);
        imageLoaderConfiguration2.slowNetworkDownloader = new SlowNetworkImageDownloader(imageDownloader);
        imageLoaderConfiguration.reserveDiscCache = DefaultConfigurationFactory.createReserveDiscCache(StorageUtils.getCacheDirectory(builder.context, false));
    }

    public static ImageLoaderConfiguration createDefault(Context context) {
        return new Builder(context).build();
    }

    ImageSize getMaxImageSize() {
        int n2;
        ImageLoaderConfiguration imageLoaderConfiguration = this;
        DisplayMetrics displayMetrics = imageLoaderConfiguration.resources.getDisplayMetrics();
        int n3 = imageLoaderConfiguration.maxImageWidthForMemoryCache;
        if (n3 <= 0) {
            n3 = displayMetrics.widthPixels;
        }
        if ((n2 = this.maxImageHeightForMemoryCache) <= 0) {
            n2 = displayMetrics.heightPixels;
        }
        return new ImageSize(n3, n2);
    }

    public static class Builder {
        private static final String WARNING_OVERLAP_DISC_CACHE_PARAMS = "discCache(), discCacheSize() and discCacheFileCount calls overlap each other";
        private static final String WARNING_OVERLAP_DISC_CACHE_NAME_GENERATOR = "discCache() and discCacheFileNameGenerator() calls overlap each other";
        private static final String WARNING_OVERLAP_MEMORY_CACHE = "memoryCache() and memoryCacheSize() calls overlap each other";
        private static final String WARNING_OVERLAP_EXECUTOR = "threadPoolSize(), threadPriority() and tasksProcessingOrder() calls can overlap taskExecutor() and taskExecutorForCachedImages() calls.";
        public static final int DEFAULT_THREAD_POOL_SIZE = 3;
        public static final int DEFAULT_THREAD_PRIORITY = 4;
        public static final QueueProcessingType DEFAULT_TASK_PROCESSING_TYPE = QueueProcessingType.FIFO;
        private Context context;
        private int maxImageWidthForMemoryCache = 0;
        private int maxImageHeightForMemoryCache = 0;
        private int maxImageWidthForDiscCache = 0;
        private int maxImageHeightForDiscCache = 0;
        private Bitmap.CompressFormat imageCompressFormatForDiscCache = null;
        private int imageQualityForDiscCache = 0;
        private BitmapProcessor processorForDiscCache = null;
        private Executor taskExecutor = null;
        private Executor taskExecutorForCachedImages = null;
        private boolean customExecutor = false;
        private boolean customExecutorForCachedImages = false;
        private int threadPoolSize = 3;
        private int threadPriority = 4;
        private boolean denyCacheImageMultipleSizesInMemory = false;
        private QueueProcessingType tasksProcessingType = DEFAULT_TASK_PROCESSING_TYPE;
        private int memoryCacheSize = 0;
        private int discCacheSize = 0;
        private int discCacheFileCount = 0;
        private MemoryCacheAware memoryCache = null;
        private DiscCacheAware discCache = null;
        private FileNameGenerator discCacheFileNameGenerator = null;
        private ImageDownloader downloader = null;
        private ImageDecoder decoder;
        private DisplayImageOptions defaultDisplayImageOptions = null;
        private boolean writeLogs = false;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        private void initEmptyFieldsWithDefaultValues() {
            int n2;
            if (this.taskExecutor == null) {
                Builder builder = this;
                n2 = builder.threadPriority;
                this.taskExecutor = DefaultConfigurationFactory.createExecutor(this.threadPoolSize, n2, builder.tasksProcessingType);
            } else {
                this.customExecutor = true;
            }
            if (this.taskExecutorForCachedImages == null) {
                Builder builder = this;
                n2 = builder.threadPriority;
                this.taskExecutorForCachedImages = DefaultConfigurationFactory.createExecutor(this.threadPoolSize, n2, builder.tasksProcessingType);
            } else {
                this.customExecutorForCachedImages = true;
            }
            if (this.discCache == null) {
                if (this.discCacheFileNameGenerator == null) {
                    this.discCacheFileNameGenerator = DefaultConfigurationFactory.createFileNameGenerator();
                }
                Builder builder = this;
                FileNameGenerator fileNameGenerator = builder.discCacheFileNameGenerator;
                int n3 = builder.discCacheSize;
                int n4 = builder.discCacheFileCount;
                this.discCache = DefaultConfigurationFactory.createDiscCache(this.context, fileNameGenerator, n3, n4);
            }
            if (this.memoryCache == null) {
                this.memoryCache = DefaultConfigurationFactory.createMemoryCache(this.memoryCacheSize);
            }
            if (this.denyCacheImageMultipleSizesInMemory) {
                FuzzyKeyMemoryCache fuzzyKeyMemoryCache;
                FuzzyKeyMemoryCache fuzzyKeyMemoryCache2 = fuzzyKeyMemoryCache;
                fuzzyKeyMemoryCache = new FuzzyKeyMemoryCache(this.memoryCache, MemoryCacheUtil.createFuzzyKeyComparator());
                this.memoryCache = fuzzyKeyMemoryCache2;
            }
            if (this.downloader == null) {
                this.downloader = DefaultConfigurationFactory.createImageDownloader(this.context);
            }
            if (this.decoder == null) {
                this.decoder = DefaultConfigurationFactory.createImageDecoder(this.writeLogs);
            }
            if (this.defaultDisplayImageOptions == null) {
                this.defaultDisplayImageOptions = DisplayImageOptions.createSimple();
            }
        }

        public Builder memoryCacheExtraOptions(int n2, int n3) {
            this.maxImageWidthForMemoryCache = n2;
            this.maxImageHeightForMemoryCache = n3;
            return this;
        }

        public Builder discCacheExtraOptions(int n2, int n3, Bitmap.CompressFormat compressFormat, int n4, BitmapProcessor bitmapProcessor) {
            this.maxImageWidthForDiscCache = n2;
            this.maxImageHeightForDiscCache = n3;
            this.imageCompressFormatForDiscCache = compressFormat;
            this.imageQualityForDiscCache = n4;
            this.processorForDiscCache = bitmapProcessor;
            return this;
        }

        public Builder taskExecutor(Executor executor) {
            if (this.threadPoolSize != 3 || this.threadPriority != 4 || this.tasksProcessingType != DEFAULT_TASK_PROCESSING_TYPE) {
                L.w(WARNING_OVERLAP_EXECUTOR, new Object[0]);
            }
            this.taskExecutor = executor;
            return this;
        }

        public Builder taskExecutorForCachedImages(Executor executor) {
            if (this.threadPoolSize != 3 || this.threadPriority != 4 || this.tasksProcessingType != DEFAULT_TASK_PROCESSING_TYPE) {
                L.w(WARNING_OVERLAP_EXECUTOR, new Object[0]);
            }
            this.taskExecutorForCachedImages = executor;
            return this;
        }

        public Builder threadPoolSize(int n2) {
            if (this.taskExecutor != null || this.taskExecutorForCachedImages != null) {
                L.w(WARNING_OVERLAP_EXECUTOR, new Object[0]);
            }
            this.threadPoolSize = n2;
            return this;
        }

        public Builder threadPriority(int n2) {
            if (this.taskExecutor != null || this.taskExecutorForCachedImages != null) {
                L.w(WARNING_OVERLAP_EXECUTOR, new Object[0]);
            }
            this.threadPriority = n2 < 1 ? 1 : (n2 > 10 ? 10 : n2);
            return this;
        }

        public Builder denyCacheImageMultipleSizesInMemory() {
            this.denyCacheImageMultipleSizesInMemory = true;
            return this;
        }

        public Builder tasksProcessingOrder(QueueProcessingType queueProcessingType) {
            if (this.taskExecutor != null || this.taskExecutorForCachedImages != null) {
                L.w(WARNING_OVERLAP_EXECUTOR, new Object[0]);
            }
            this.tasksProcessingType = queueProcessingType;
            return this;
        }

        public Builder memoryCacheSize(int n2) {
            if (n2 > 0) {
                if (this.memoryCache != null) {
                    L.w(WARNING_OVERLAP_MEMORY_CACHE, new Object[0]);
                }
                this.memoryCacheSize = n2;
                return this;
            }
            throw new IllegalArgumentException("memoryCacheSize must be a positive number");
        }

        public Builder memoryCacheSizePercentage(int n2) {
            if (n2 > 0 && n2 < 100) {
                if (this.memoryCache != null) {
                    L.w(WARNING_OVERLAP_MEMORY_CACHE, new Object[0]);
                }
                this.memoryCacheSize = (int)((float)Runtime.getRuntime().maxMemory() * ((float)n2 / 100.0f));
                return this;
            }
            throw new IllegalArgumentException("availableMemoryPercent must be in range (0 < % < 100)");
        }

        public Builder memoryCache(MemoryCacheAware memoryCacheAware) {
            if (this.memoryCacheSize != 0) {
                L.w(WARNING_OVERLAP_MEMORY_CACHE, new Object[0]);
            }
            this.memoryCache = memoryCacheAware;
            return this;
        }

        public Builder discCacheSize(int n2) {
            if (n2 > 0) {
                if (this.discCache != null || this.discCacheFileCount > 0) {
                    L.w(WARNING_OVERLAP_DISC_CACHE_PARAMS, new Object[0]);
                }
                this.discCacheSize = n2;
                return this;
            }
            throw new IllegalArgumentException("maxCacheSize must be a positive number");
        }

        public Builder discCacheFileCount(int n2) {
            if (n2 > 0) {
                if (this.discCache != null || this.discCacheSize > 0) {
                    L.w(WARNING_OVERLAP_DISC_CACHE_PARAMS, new Object[0]);
                }
                this.discCacheSize = 0;
                this.discCacheFileCount = n2;
                return this;
            }
            throw new IllegalArgumentException("maxFileCount must be a positive number");
        }

        public Builder discCacheFileNameGenerator(FileNameGenerator fileNameGenerator) {
            if (this.discCache != null) {
                L.w(WARNING_OVERLAP_DISC_CACHE_NAME_GENERATOR, new Object[0]);
            }
            this.discCacheFileNameGenerator = fileNameGenerator;
            return this;
        }

        public Builder imageDownloader(ImageDownloader imageDownloader) {
            this.downloader = imageDownloader;
            return this;
        }

        public Builder imageDecoder(ImageDecoder imageDecoder) {
            this.decoder = imageDecoder;
            return this;
        }

        public Builder discCache(DiscCacheAware discCacheAware) {
            if (this.discCacheSize > 0 || this.discCacheFileCount > 0) {
                L.w(WARNING_OVERLAP_DISC_CACHE_PARAMS, new Object[0]);
            }
            if (this.discCacheFileNameGenerator != null) {
                L.w(WARNING_OVERLAP_DISC_CACHE_NAME_GENERATOR, new Object[0]);
            }
            this.discCache = discCacheAware;
            return this;
        }

        public Builder defaultDisplayImageOptions(DisplayImageOptions displayImageOptions) {
            this.defaultDisplayImageOptions = displayImageOptions;
            return this;
        }

        public Builder writeDebugLogs() {
            this.writeLogs = true;
            return this;
        }

        public ImageLoaderConfiguration build() {
            this.initEmptyFieldsWithDefaultValues();
            return new ImageLoaderConfiguration(this);
        }
    }
}

