/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;

public final class WebSocketProtocol {
    static final String ACCEPT_MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    static final int B0_FLAG_FIN = 128;
    static final int B0_FLAG_RSV1 = 64;
    static final int B0_FLAG_RSV2 = 32;
    static final int B0_FLAG_RSV3 = 16;
    static final int B0_MASK_OPCODE = 15;
    static final int OPCODE_FLAG_CONTROL = 8;
    static final int B1_FLAG_MASK = 128;
    static final int B1_MASK_LENGTH = 127;
    static final int OPCODE_CONTINUATION = 0;
    static final int OPCODE_TEXT = 1;
    static final int OPCODE_BINARY = 2;
    static final int OPCODE_CONTROL_CLOSE = 8;
    static final int OPCODE_CONTROL_PING = 9;
    static final int OPCODE_CONTROL_PONG = 10;
    static final long PAYLOAD_BYTE_MAX = 125L;
    static final long CLOSE_MESSAGE_MAX = 123L;
    static final int PAYLOAD_SHORT = 126;
    static final long PAYLOAD_SHORT_MAX = 65535L;
    static final int PAYLOAD_LONG = 127;
    static final int CLOSE_CLIENT_GOING_AWAY = 1001;
    static final int CLOSE_NO_STATUS_CODE = 1005;

    static void toggleMask(Buffer.UnsafeCursor unsafeCursor, byte[] byArray) {
        int n2 = 0;
        int n3 = byArray.length;
        do {
            Buffer.UnsafeCursor unsafeCursor2 = unsafeCursor;
            byte[] byArray2 = unsafeCursor2.data;
            int n4 = unsafeCursor2.start;
            int n5 = unsafeCursor2.end;
            while (n4 < n5) {
                byArray2[n4] = (byte)(byArray2[n4] ^ byArray[n2 %= n3]);
                ++n4;
                ++n2;
            }
        } while (unsafeCursor.next() != -1);
    }

    static String closeCodeExceptionMessage(int n2) {
        if (n2 >= 1000 && n2 < 5000) {
            if (n2 >= 1004 && n2 <= 1006 || n2 >= 1012 && n2 <= 2999) {
                return "Code " + n2 + " is reserved and may not be used.";
            }
            return null;
        }
        return "Code must be in range [1000,5000): " + n2;
    }

    static void validateCloseCode(int n2) {
        String string2 = WebSocketProtocol.closeCodeExceptionMessage(n2);
        if (string2 == null) {
            return;
        }
        throw new IllegalArgumentException(string2);
    }

    public static String acceptHeader(String string2) {
        return ByteString.encodeUtf8(string2 + ACCEPT_MAGIC).sha1().base64();
    }

    private WebSocketProtocol() {
        throw new AssertionError((Object)"No instances.");
    }
}

