/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import pl.droidsonroids.gif.transforms.Transform;

public class GIFCornerRadiusTransform
implements Transform {
    private float mCornerRadius;
    private Shader mShader;
    private final RectF mDstRectF;
    private int gifViewWidth;

    public GIFCornerRadiusTransform(float f2, int n2) {
        RectF rectF;
        GIFCornerRadiusTransform gIFCornerRadiusTransform = gIFCornerRadiusTransform2;
        GIFCornerRadiusTransform gIFCornerRadiusTransform2 = rectF;
        rectF = new RectF();
        gIFCornerRadiusTransform.mDstRectF = gIFCornerRadiusTransform2;
        gIFCornerRadiusTransform.gifViewWidth = -1;
        gIFCornerRadiusTransform.setCornerRadiusSafely(f2);
        gIFCornerRadiusTransform.gifViewWidth = n2;
    }

    private void setCornerRadiusSafely(float f2) {
        if ((f2 = Math.max(0.0f, f2)) != this.mCornerRadius) {
            GIFCornerRadiusTransform gIFCornerRadiusTransform = this;
            gIFCornerRadiusTransform.mCornerRadius = f2;
            gIFCornerRadiusTransform.mShader = null;
        }
    }

    public void setCornerRadius(float f2) {
        this.setCornerRadiusSafely(f2);
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public RectF getBounds() {
        return this.mDstRectF;
    }

    public void onBoundsChange(Rect rect) {
        this.mDstRectF.set(rect);
        this.mShader = null;
    }

    public void onDraw(Canvas canvas, Paint paint, Bitmap bitmap) {
        GIFCornerRadiusTransform gIFCornerRadiusTransform;
        if (gIFCornerRadiusTransform.mCornerRadius == 0.0f) {
            gIFCornerRadiusTransform = gIFCornerRadiusTransform.mDstRectF;
            canvas.drawBitmap(bitmap, null, (RectF)gIFCornerRadiusTransform, paint);
        } else {
            if (gIFCornerRadiusTransform.mShader == null) {
                Matrix matrix;
                Shader.TileMode tileMode = Shader.TileMode.CLAMP;
                gIFCornerRadiusTransform.mShader = new BitmapShader(bitmap, tileMode, tileMode);
                Matrix matrix2 = matrix;
                matrix2();
                RectF rectF = gIFCornerRadiusTransform.mDstRectF;
                float f2 = rectF.left;
                matrix2.setTranslate(f2, rectF.top);
                matrix.preScale(gIFCornerRadiusTransform.mDstRectF.width() / (float)bitmap.getWidth(), gIFCornerRadiusTransform.mDstRectF.height() / (float)bitmap.getHeight());
                gIFCornerRadiusTransform.mShader.setLocalMatrix(matrix2);
            }
            paint.setShader(gIFCornerRadiusTransform.mShader);
            float f3 = 1.0f;
            if (gIFCornerRadiusTransform.gifViewWidth > 0) {
                f3 = gIFCornerRadiusTransform.mDstRectF.width() / (float)gIFCornerRadiusTransform.gifViewWidth;
            }
            GIFCornerRadiusTransform gIFCornerRadiusTransform2 = gIFCornerRadiusTransform;
            paint.setAntiAlias(true);
            gIFCornerRadiusTransform = gIFCornerRadiusTransform2.mDstRectF;
            float f4 = gIFCornerRadiusTransform2.mCornerRadius;
            float f5 = f4 * f3;
            f3 = f4 * f3;
            canvas.drawRoundRect((RectF)gIFCornerRadiusTransform, f5, f3, paint);
        }
    }
}

