/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.net;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IReqListener;
import io.dcloud.common.DHInterface.IResponseListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.constant.StringConst;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.common.util.net.DownloadMgr;
import io.dcloud.common.util.net.NetWork;
import io.dcloud.common.util.net.RequestData;
import io.dcloud.net.DownloadJSMgr;
import io.dcloud.net.DownloadNetWork;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class JsDownload
implements IReqListener,
IResponseListener {
    static final int STATE_UNDEFINED = -1000;
    static final int STATE_UNKOWN = -1;
    static final int STATE_INIT = 0;
    static final int STATE_CONNECTING = 1;
    static final int STATE_CONNECTED = 2;
    static final int STATE_RECEIVING = 3;
    static final int STATE_COMPLETED = 4;
    static final int STATE_PAUSE = 5;
    public static final String DOWNLOAD_NAME = "_download_dcloud";
    int mState = -1000;
    String mUUID = null;
    String mUrl = null;
    String mRealURL = null;
    boolean append = false;
    private long responseOffset = 0L;
    private String sAppid;
    private String sharedPreferenceName;
    private boolean mDownloadComplete;
    DownloadNetWork mDownloadNetWork = null;
    RequestData mRequestData = null;
    public IWebview mWebview = null;
    private ArrayList<IWebview> mRelWebviews = null;
    JSONObject mOptions = null;
    String mFileName = "";
    private String mParentPath = null;
    private File mFile = null;
    RandomAccessFile mFileOs = null;
    long mFileSize = 0L;
    long mTotalSize = 0L;
    String mMethod;
    int mPriority;
    int mRetry = 3;
    String mData;
    private long mRetryIntervalTime;
    String mConfigFilePath = null;
    private DownloadJSMgr mDownloadMgr = null;
    public boolean mPause;
    public boolean mAbort;
    private long preTime = 0L;

    JsDownload(DownloadJSMgr object, IWebview iWebview, JSONObject jSONObject) {
        DownloadNetWork downloadNetWork;
        RequestData requestData;
        ArrayList arrayList;
        this.mDownloadMgr = object;
        this.mWebview = iWebview;
        object = arrayList;
        ArrayList arrayList2 = object;
        arrayList2();
        this.mRelWebviews = arrayList2;
        arrayList.add(iWebview);
        this.parseJson(jSONObject);
        Object object2 = object = requestData;
        JsDownload jsDownload = this;
        object = jsDownload.mUrl;
        ((RequestData)object2)((String)object, jsDownload.mMethod);
        this.mRequestData = object2;
        requestData.unTrustedCAType = iWebview.obtainApp().obtainConfigProperty("untrustedca");
        if (!jSONObject.isNull("timeout")) {
            this.mRequestData.mTimeout = jSONObject.optInt("timeout") * 1000;
        }
        JsDownload jsDownload2 = this;
        jsDownload2.mRequestData.addHeader("User-Agent", iWebview.getWebviewProperty("User-Agent"));
        Object object3 = object = downloadNetWork;
        JsDownload jsDownload3 = this;
        ((DownloadNetWork)object3)(2, this.mRequestData, jsDownload3, jsDownload3);
        this.mDownloadNetWork = object3;
        ((NetWork)object).MAX_TIMES = this.mRetry;
        ((NetWork)object).mPriority = this.mPriority;
        downloadNetWork.setRetryIntervalTime(this.mRetryIntervalTime);
        jsDownload2.sAppid = jsDownload2.mWebview.obtainFrameView().obtainApp().obtainAppId();
        jsDownload2.sharedPreferenceName = this.sAppid + DOWNLOAD_NAME;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseJson(JSONObject jSONObject) {
        void var2_11;
        String string2;
        block11: {
            File file;
            String string3;
            String[] stringArray;
            String string4;
            File file2;
            String string5;
            this.mOptions = jSONObject.optJSONObject("options");
            this.mUrl = JSONUtil.getString(jSONObject, "url");
            String string6 = JSONUtil.getString(jSONObject, "RealURL");
            if (string6 != null && !string6.equalsIgnoreCase("null") && !string6.equalsIgnoreCase(this.mUrl)) {
                this.mUrl = string6;
            }
            this.mUUID = string5 = JSONUtil.getString(jSONObject, "id");
            if (TextUtils.isEmpty((CharSequence)string5)) {
                this.mUUID = JSONUtil.getString(jSONObject, "uuid");
            }
            this.mMethod = JSONUtil.getString(jSONObject, "method");
            this.mPriority = JSONUtil.getInt(jSONObject, "priority");
            this.mRetry = JSONUtil.getInt(jSONObject, "retry");
            this.mFileSize = JSONUtil.getInt(jSONObject, "downloadedSize");
            this.mTotalSize = JSONUtil.getInt(jSONObject, "totalSize");
            String string7 = JSONUtil.getString(jSONObject, "state");
            if (!PdrUtil.isEmpty(string7)) {
                try {
                    this.mState = Integer.parseInt(string7);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            this.mConfigFilePath = BaseInfo.sDownloadFullPath + this.mUUID + ".download";
            File file3 = file2;
            try {
                if (!new File(this.mConfigFilePath).exists()) break block11;
                JsDownload jsDownload = this;
                String string8 = IOUtil.toString(new FileInputStream(file3));
                string4 = string8;
                string8.replace("\n", "");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break block11;
            }
            {
                stringArray = string4.split("-");
            }
            {
                this.mTotalSize = Long.parseLong(stringArray[0]);
                this.mState = Integer.parseInt(stringArray[2]);
                string3 = stringArray[3].replace("\n", "");
            }
            File file4 = file;
            {
                jsDownload.mFile = new File(string3);
                this.mFileSize = file4.exists() ? this.mFile.length() : 0L;
            }
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = JSONUtil.getString(jSONObject, "filename")))) {
            String string9 = JSONUtil.getString(this.mOptions, "filename");
        }
        this.initPath((String)var2_11);
        this.mData = JSONUtil.getString(jSONObject, "data");
        this.mRetryIntervalTime = JSONUtil.getLong(jSONObject, "retryInterval") * 1000L;
    }

    private static boolean startsWith(String string2, String string3, boolean bl) {
        if (string2 != null && string2.startsWith(string3)) {
            if (bl) {
                return (string2 = string2.substring(string3.length())).length() == 0 || string2.length() > 1 && string2.charAt(0) == '/';
            }
            return true;
        }
        return false;
    }

    private void initPath(String string2) {
        IApp iApp = this.mWebview.obtainFrameView().obtainApp();
        if (PdrUtil.isEmpty(string2)) {
            JsDownload jsDownload = this;
            jsDownload.mParentPath = new File(BaseInfo.sDownloadFullPath).getParent() + "/";
            jsDownload.mFileName = "_downloads/";
        } else {
            this.mFileName = string2;
            this.mParentPath = JsDownload.startsWith(string2, "_doc", true) ? new File(iApp.obtainAppDocPath()).getParent() + "/" : (JsDownload.startsWith(string2, "_documents", true) ? new File(BaseInfo.sDocumentFullPath).getParent() + "/" : (JsDownload.startsWith(string2, "_downloads", true) ? new File(BaseInfo.sDownloadFullPath).getParent() + "/" : new File(BaseInfo.sDownloadFullPath).getParent() + "/"));
        }
    }

    private void onStateChanged(int n2) {
        int n3;
        if (n2 == 3 || n2 == 5) {
            this.mState = n2;
        }
        if ((n3 = n2 == 3 && SystemClock.elapsedRealtime() - this.preTime >= 10L ? 1 : 0) != 0 || n2 != 3 || this.mTotalSize - this.mFileSize <= 5120L || this.mAbort) {
            if (n3 != 0) {
                this.preTime = SystemClock.elapsedRealtime();
            }
            JsDownload jsDownload = this;
            String string2 = jsDownload.toJSON();
            n3 = jsDownload.mRelWebviews.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                JSUtil.excDownloadCallBack(this.mRelWebviews.get(i2), string2, this.mUUID);
            }
        }
        if (this.mAbort) {
            return;
        }
        this.saveDownloadState();
    }

    private void saveDownloadState() {
        block6: {
            if (this.mFileSize < this.mTotalSize) {
                FileOutputStream fileOutputStream;
                File file;
                File file2 = file;
                if (!new File(this.mConfigFilePath).exists()) break block6;
                FileOutputStream fileOutputStream2 = fileOutputStream;
                fileOutputStream = new FileOutputStream(file2, false);
                FileOutputStream fileOutputStream3 = fileOutputStream;
                try {
                    fileOutputStream2.write((this.mTotalSize + "-" + this.mFileSize + "-" + this.mState + "-" + this.mFile.getAbsolutePath()).getBytes());
                    fileOutputStream3.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private boolean justDirPath() {
        return TextUtils.isEmpty((CharSequence)this.mFileName) || this.mFileName.endsWith("/");
    }

    private File createDownloadFile(boolean bl) {
        block23: {
            File file;
            Object object;
            String string2;
            block27: {
                String string3;
                String string4;
                int n2;
                block26: {
                    block25: {
                        block24: {
                            File file2;
                            JsDownload jsDownload = this;
                            string2 = jsDownload.getRealPath(jsDownload.mFileName);
                            if (string2 == null) break block23;
                            boolean bl2 = bl;
                            object = file2;
                            file2 = new File(string2);
                            if (bl2) {
                                if (!((File)object).exists()) break block24;
                                return object;
                            }
                        }
                        string2 = this.mFileName;
                        n2 = string2.lastIndexOf(".");
                        if (n2 >= 0) break block25;
                        string4 = string2;
                        break block26;
                    }
                    string4 = string2.substring(0, n2);
                }
                if (n2 < 0) {
                    string3 = "";
                } else {
                    string3 = string2.substring(n2);
                }
                int n3 = 1;
                while (true) {
                    File file3;
                    if (!((File)object).exists()) break;
                    JsDownload jsDownload = this;
                    string2 = string4 + "(" + n3 + ")" + string3;
                    object = jsDownload.getRealPath(string2);
                    File file4 = file3;
                    file3 = new File((String)object);
                    ++n3;
                    object = file4;
                    continue;
                    break;
                }
                this.mFileName = string2;
                if (((File)object).getParentFile().exists()) break block27;
                ((File)object).getParentFile().mkdirs();
            }
            try {
                File file5 = object;
                file = file5;
                file5.createNewFile();
            }
            catch (Exception exception) {
                string2 = this.mFileName;
                if (string2 != null && string2.toLowerCase(Locale.ENGLISH).startsWith("file://")) {
                    JsDownload jsDownload = this;
                    jsDownload.mFileName = jsDownload.mFileName.substring(7);
                    return jsDownload.createDownloadFile(jsDownload.append);
                }
                exception.printStackTrace();
            }
            return file;
        }
        return null;
    }

    private void checkSpecialFile(String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && BaseInfo.ISAMU) {
            int n2 = string2.length();
            String string3 = StringConst.POINT_APP_EN;
            String string4 = ".wgt";
            String string5 = ".wgtu";
            if ((n2 - string2.indexOf(string3) - string3.length() == 0 || n2 - string2.indexOf(string4) - 4 == 0 || n2 - string2.indexOf(string5) - 5 == 0) && this.mWebview != null) {
                JSONObject jSONObject;
                string2 = jSONObject;
                JsDownload jsDownload = this;
                String string6 = string2;
                String string7 = string6;
                string6();
                string6.put("type", (Object)"download");
                string7.put("file", (Object)(this.mParentPath + this.mFileName));
                String string8 = "url";
                jSONObject.put(string8, (Object)jsDownload.mUrl);
                jSONObject.put("appid", (Object)this.mWebview.obtainApp().obtainOriginalAppId());
                jSONObject.put("version", (Object)this.mWebview.obtainApp().obtainAppVersionName());
                try {
                    Log.i((String)".stream_json", (String)string2.toString());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onNetStateChanged(IReqListener.NetState var1_1, boolean var2_3) {
        block38: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block37: {
                                    if (this.mPause) {
                                        return;
                                    }
                                    if (var1_1 != IReqListener.NetState.NET_INIT) break block37;
                                    v0 = this;
                                    v0.mState = 0;
                                    v0.mDownloadComplete = false;
                                    break block38;
                                }
                                if (var1_1 != IReqListener.NetState.NET_CONNECTED) break block39;
                                this.mState = 2;
                                break block38;
                            }
                            if (var1_1 != IReqListener.NetState.NET_HANDLE_END) break block40;
                            v1 = this;
                            v1.mState = 4;
                            Logger.d("----NetState.NET_HANDLE_END-----");
                            DownloadMgr.getDownloadMgr().removeTask(this.mDownloadNetWork);
                            v1.deleteDownloadData();
                            v1.saveInDatabase();
                            v1.mDownloadComplete = true;
                            v1.checkSpecialFile(v1.mFileName);
                            break block38;
                        }
                        if (var1_1 != IReqListener.NetState.NET_ERROR) break block41;
                        this.mState = 4;
                        this.mDownloadNetWork.mStatus = 400;
                        Logger.d("----NetState.NET_ERROR-----");
                        DownloadMgr.getDownloadMgr().removeTask(this.mDownloadNetWork);
                        if (this.mDownloadComplete) {
                            return;
                        }
                        break block38;
                    }
                    if (var1_1 != IReqListener.NetState.NET_TIMEOUT) break block42;
                    this.mState = 4;
                    this.mDownloadNetWork.mStatus = 0;
                    Logger.d("----NetState.NET_TIMEOUT-----");
                    DownloadMgr.getDownloadMgr().removeTask(this.mDownloadNetWork);
                    if (this.mDownloadComplete) {
                        return;
                    }
                    break block38;
                }
                if (var1_1 != IReqListener.NetState.NET_REQUEST_BEGIN) break block43;
                if (this.mFileSize <= 0L) ** GOTO lbl49
                v2 = this.mDownloadNetWork.mUrlConn;
                v2.setRequestProperty("Range", "bytes=" + String.valueOf(this.mFileSize) + "-");
lbl49:
                // 2 sources

                v3 = this;
                v3.mDownloadNetWork.mUrlConn.setRequestMethod(this.mMethod);
                if (!v3.mMethod.equals("POST")) ** GOTO lbl59
                try {
                    v4 = this;
                    v4.mDownloadNetWork.mUrlConn.setDoOutput(true);
                    v4.mDownloadNetWork.mUrlConn.getOutputStream().write(this.mData.getBytes("utf8"));
                    v4.mDownloadNetWork.mUrlConn.getOutputStream().flush();
                    v4.mDownloadNetWork.mUrlConn.getOutputStream().close();
                    v4.mDownloadNetWork.mUrlConn.setChunkedStreamingMode(0);
lbl59:
                    // 2 sources

                    v5 = this;
                    v5.mDownloadNetWork.mUrlConn.setConnectTimeout(this.mRequestData.mTimeout);
                    v5.mDownloadNetWork.mUrlConn.setReadTimeout(this.mRequestData.mTimeout);
                }
                catch (Exception v6) {
                    v6.printStackTrace();
                }
                break block38;
            }
            if (var1_1 == IReqListener.NetState.NET_HANDLE_BEGIN) {
                block34: {
                    v7 = this;
                    var1_1 = v7.mDownloadNetWork.mUrlConn.getHeaderField("Content-Length");
                    var2_4 = v7.mDownloadNetWork.mUrlConn.getHeaderField("Content-Range");
                    var3_6 = v7.mDownloadNetWork.mUrlConn.getHeaderField("Content-Type");
                    var4_7 = v7.mDownloadNetWork.mUrlConn.getHeaderField("Set-Cookie");
                    if (!PdrUtil.isEmpty(var4_7)) {
                        CookieManager.getInstance().setCookie(this.mRequestData.getUrl(), var4_7);
                    }
                    if (var2_4 == null) {
                        this.mTotalSize = PdrUtil.parseLong((String)var1_1, 0L);
                        this.mFileSize = 0L;
                        this.responseOffset = 0L;
                        var1_1 = this.mFile;
                        if (var1_1 != null && var1_1.exists()) {
                            this.mFile.delete();
                            new File(this.mConfigFilePath).delete();
                        }
                    } else {
                        this.append = true;
                        v8 = new MessageFormat("bytes {0,number}-{1,number}");
                        v8.setLocale(Locale.US);
                        var1_2 = ((Number)v8.parse(var2_4)[0]).longValue();
                        this.responseOffset = var1_2;
                        if (var1_2 >= 0L) break block34;
                        try {
                            this.responseOffset = 0L;
                        }
                        catch (Exception v9) {
                            this.responseOffset = 0L;
                        }
                    }
                }
                if (this.justDirPath()) {
                    block35: {
                        block36: {
                            var1_1 = this.mDownloadNetWork.mUrlConn.getHeaderField("content-disposition");
                            if (!PdrUtil.isEmpty(var1_1)) break block35;
                            var2_4 = this.mDownloadNetWork.mUrlConn.getURL().getFile().toString();
                            var4_8 = var2_4.lastIndexOf(47);
                            if (var4_8 < 0) break block35;
                            var2_4 = var2_4.substring(var4_8 + 1);
                            if (var2_4.indexOf(46) < 0) break block35;
                            if (!var2_4.contains("?")) break block36;
                            v10 = var2_4;
                            var2_5 = 0;
                            var2_4 = v10.substring(var2_5, v10.indexOf("?"));
                        }
                        v11 = this;
                        try {
                            v11.mFileName = this.mFileName + var2_4;
                        }
                        catch (Exception v12) {
                            v12.printStackTrace();
                        }
                    }
                    if (this.justDirPath()) {
                        this.mFileName = this.mFileName + PdrUtil.getDownloadFilename((String)var1_1, var3_6, this.mUrl);
                    }
                }
                if (this.mDownloadNetWork.isStop) {
                    return;
                }
                v13 = this;
                v13.mFile = v13.createDownloadFile(v13.append);
                var1_1 = v14;
                try {
                    v15 = var1_1;
                    v15(this.mFile, "rw");
                    this.mFileOs = v15;
                    v14.seek(this.responseOffset);
                }
                catch (IOException v16) {
                    v16.printStackTrace();
                    this.saveInDatabase();
                }
                return;
            }
        }
        v17 = this;
        v17.onStateChanged(v17.mState);
    }

    @Override
    public void onResponsing(InputStream object) {
        JsDownload jsDownload = this;
        object = jsDownload.toJSON();
        jsDownload.mState = 1;
        int n2 = jsDownload.mRelWebviews.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSUtil.excDownloadCallBack(this.mRelWebviews.get(i2), (String)object, this.mUUID);
        }
    }

    @Override
    public int onReceiving(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[10240];
        if (inputStream != null) {
            int n2;
            this.mDownloadNetWork.mTimes = 1;
            boolean bl = false;
            while ((n2 = inputStream.read(byArray)) != -1) {
                if (this.mPause) {
                    this.onStateChanged(5);
                    return -1;
                }
                JsDownload jsDownload = this;
                jsDownload.mFileOs.write(byArray, 0, n2);
                jsDownload.mFileSize += (long)n2;
                jsDownload.onStateChanged(3);
                if (bl) continue;
                JsDownload jsDownload2 = this;
                bl = true;
                jsDownload2.mRealURL = jsDownload2.mDownloadNetWork.mUrlConn.getURL().toString();
                jsDownload2.saveInDatabase();
            }
            this.mFileOs.close();
        }
        if (this.mFileSize >= this.mTotalSize) {
            new File(this.mConfigFilePath).delete();
            return -1;
        }
        throw new RuntimeException();
    }

    public String toJSON() {
        String string2;
        Object[] objectArray = "{status: %d,state: %d,filename: '%s',uuid: '%s',downloadedSize:%d,totalSize:%d,headers:%s}";
        if (this.mState == -1000) {
            Object[] objectArray2 = new Object[6];
            objectArray = objectArray2;
            objectArray[0] = this.mDownloadNetWork.mStatus;
            objectArray[1] = this.mFileName;
            objectArray[2] = this.mUUID;
            objectArray[3] = this.mFileSize;
            objectArray[4] = this.mTotalSize;
            objectArray2[5] = this.mDownloadNetWork.getResponseHeaders();
            string2 = StringUtil.format("{status: %d,filename: '%s',uuid: '%s',downloadedSize:%d,totalSize:%d,headers:%s}", objectArray);
        } else {
            Object[] objectArray3 = objectArray;
            Object[] objectArray4 = new Object[7];
            objectArray = objectArray4;
            objectArray[0] = this.mDownloadNetWork.mStatus;
            objectArray[1] = this.mState;
            objectArray[2] = this.mFileName;
            objectArray[3] = this.mUUID;
            objectArray[4] = this.mFileSize;
            objectArray[5] = this.mTotalSize;
            objectArray4[6] = this.mDownloadNetWork.getResponseHeaders();
            string2 = StringUtil.format((String)objectArray3, objectArray4);
        }
        return string2;
    }

    public void start() {
        this.mDownloadNetWork.mTimes = 1;
        this.mPause = false;
        DownloadMgr.getDownloadMgr().addQuestTask(this.mDownloadNetWork);
        this.saveInDatabase();
    }

    public void abort() {
        try {
            this.mAbort = true;
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    v0.JsDownload.this.mDownloadNetWork.cancelWork();
                    DownloadMgr.getDownloadMgr().removeTask(JsDownload.this.mDownloadNetWork);
                    v0.JsDownload.this.deleteDownloadData();
                    if (!PdrUtil.isEmpty(v0.JsDownload.this.mFileOs)) {
                        try {
                            JsDownload.this.mFileOs.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (JsDownload.this.mFile != null) {
                        JsDownload.this.mFile.delete();
                    }
                    JsDownload.this.mWebview = null;
                    JsDownload.this.mRelWebviews.clear();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveInDatabase() {
        JsDownload jsDownload = string2;
        String string2 = jsDownload.sAppid;
        String string3 = jsDownload.mUUID;
        String string4 = jsDownload.toSaveJSON();
        ((JsDownload)((Object)string2)).mDownloadMgr.saveDownloadTaskInfo(string2, string3, string4);
    }

    public void deleteDownloadData() {
        JsDownload jsDownload = this;
        String string2 = jsDownload.sAppid;
        this.mDownloadMgr.deleteDownloadTaskInfo(string2, jsDownload.mUUID);
        new File(this.mConfigFilePath).delete();
    }

    public void addRelWebview(IWebview iWebview) {
        if (!this.mRelWebviews.contains(iWebview)) {
            this.mRelWebviews.add(iWebview);
        }
    }

    String toSaveJSON() {
        Object[] objectArray = new Object[12];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mUrl;
        objectArray2[1] = this.mUUID;
        objectArray2[2] = this.mMethod;
        objectArray2[3] = this.mPriority;
        objectArray2[4] = this.mRequestData.mTimeout;
        objectArray2[5] = this.mRetry;
        objectArray2[6] = this.mFileName;
        objectArray2[7] = this.mFileSize;
        objectArray2[8] = this.mTotalSize;
        objectArray2[9] = this.mState;
        objectArray2[10] = this.mOptions.toString();
        objectArray[11] = this.mRealURL;
        return StringUtil.format("{url: '%s',uuid: '%s',method: '%s',priority: %d,timeout:%d,retry:%d,filename:'%s',downloadedSize:%d,totalSize:%d,state: %d,options:%s,RealURL:'%s'}", objectArray2);
    }

    @Override
    public void onResponseState(int n2, String string2) {
    }

    public void setRequestHeader(String string2, String string3) {
        this.mRequestData.addHeader(string2, string3);
    }

    public String getRealPath(String string2) {
        if (string2 != null && string2.startsWith("/") && !string2.toLowerCase(Locale.ENGLISH).startsWith("/sdcard")) {
            JsDownload jsDownload = string3;
            String string3 = string2.substring(1);
            string2 = jsDownload.mWebview.obtainApp().convert2AbsFullPath(string3);
            if (string2 != null && string2.contains("/www/")) {
                string2 = string2.replace("/www/", "/" + BaseInfo.REAL_PUBLIC_DOWNLOADS_DIR);
            }
        } else if ((string2 == null || !string2.toLowerCase(Locale.ENGLISH).startsWith("/sdcard")) && (string2 = ((JsDownload)((Object)string3)).mWebview.obtainApp().convert2AbsFullPath(string2)) != null && string2.contains("/www/")) {
            string2 = string2.replace("/www/", "/" + BaseInfo.REAL_PUBLIC_DOWNLOADS_DIR);
        }
        return string2;
    }
}

