/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.io.inputstream.SplitFileInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;

public class ZipStandardSplitFileInputStream
extends SplitFileInputStream {
    protected RandomAccessFile randomAccessFile;
    protected File zipFile;
    private int lastSplitZipFileNumber;
    private boolean isSplitZipArchive;
    private int currentSplitFileCounter = 0;
    private byte[] singleByteArray = new byte[1];

    public ZipStandardSplitFileInputStream(File file, boolean bl, int n2) throws FileNotFoundException {
        this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
        this.zipFile = file;
        this.isSplitZipArchive = bl;
        this.lastSplitZipFileNumber = n2;
        if (bl) {
            this.currentSplitFileCounter = n2;
        }
    }

    @Override
    public int read() throws IOException {
        ZipStandardSplitFileInputStream zipStandardSplitFileInputStream = this;
        if (zipStandardSplitFileInputStream.read(zipStandardSplitFileInputStream.singleByteArray) == -1) {
            return -1;
        }
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (((n2 = this.randomAccessFile.read(byArray, n2, n3)) != n3 || n2 == -1) && this.isSplitZipArchive) {
            int n4;
            ZipStandardSplitFileInputStream zipStandardSplitFileInputStream = this;
            zipStandardSplitFileInputStream.openRandomAccessFileForIndex(zipStandardSplitFileInputStream.currentSplitFileCounter + 1);
            ++zipStandardSplitFileInputStream.currentSplitFileCounter;
            if (n2 < 0) {
                n2 = 0;
            }
            if ((n4 = this.randomAccessFile.read(byArray, n2, n3 - n2)) > 0) {
                n2 += n4;
            }
        }
        return n2;
    }

    @Override
    public void prepareExtractionForFileHeader(FileHeader fileHeader) throws IOException {
        if (this.isSplitZipArchive && this.currentSplitFileCounter != fileHeader.getDiskNumberStart()) {
            this.openRandomAccessFileForIndex(fileHeader.getDiskNumberStart());
            this.currentSplitFileCounter = fileHeader.getDiskNumberStart();
        }
        this.randomAccessFile.seek(fileHeader.getOffsetLocalHeader());
    }

    @Override
    public void close() throws IOException {
        Closeable closeable = ((ZipStandardSplitFileInputStream)closeable).randomAccessFile;
        if (closeable != null) {
            ((RandomAccessFile)closeable).close();
        }
    }

    protected void openRandomAccessFileForIndex(int n2) throws IOException {
        File file = this.getNextSplitFile(n2);
        if (file.exists()) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(file, RandomAccessFileMode.READ.getValue());
            return;
        }
        throw new FileNotFoundException("zip split file does not exist: " + file);
    }

    protected File getNextSplitFile(int n2) throws IOException {
        StringBuilder stringBuilder;
        if (n2 == ((ZipStandardSplitFileInputStream)((Object)string2)).lastSplitZipFileNumber) {
            return ((ZipStandardSplitFileInputStream)((Object)string2)).zipFile;
        }
        String string2 = ((ZipStandardSplitFileInputStream)((Object)string2)).zipFile.getCanonicalPath();
        String string3 = ".z0";
        if (n2 >= 9) {
            string3 = ".z";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        String string4 = string2;
        stringBuilder2();
        return new File(stringBuilder.append(string4.substring(0, string4.lastIndexOf("."))).append(string3).append(n2 + 1).toString());
    }
}

