/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.progress;

public class ProgressMonitor {
    private State state;
    private long totalWork;
    private long workCompleted;
    private int percentDone;
    private Task currentTask;
    private String fileName;
    private Result result;
    private Exception exception;
    private boolean cancelAllTasks;
    private boolean pause;

    public ProgressMonitor() {
        ProgressMonitor progressMonitor = this;
        progressMonitor.reset();
    }

    private void reset() {
        ProgressMonitor progressMonitor = this;
        progressMonitor.currentTask = Task.NONE;
        progressMonitor.state = State.READY;
    }

    public void updateWorkCompleted(long l2) {
        ProgressMonitor progressMonitor = this;
        progressMonitor.workCompleted = l2 = progressMonitor.workCompleted + l2;
        long l3 = progressMonitor.totalWork;
        if (l3 > 0L && (this.percentDone = (int)(l2 * 100L / l3)) > 100) {
            this.percentDone = 100;
        }
        while (this.pause) {
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void endProgressMonitor() {
        this.result = Result.SUCCESS;
        this.percentDone = 100;
        this.reset();
    }

    public void endProgressMonitor(Exception exception) {
        this.result = Result.ERROR;
        this.exception = exception;
        this.reset();
    }

    public void fullReset() {
        this.reset();
        this.fileName = null;
        this.totalWork = 0L;
        this.workCompleted = 0L;
        this.percentDone = 0;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getTotalWork() {
        return this.totalWork;
    }

    public void setTotalWork(long l2) {
        this.totalWork = l2;
    }

    public long getWorkCompleted() {
        return this.workCompleted;
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    public void setPercentDone(int n2) {
        this.percentDone = n2;
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(Task task) {
        this.currentTask = task;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string2) {
        this.fileName = string2;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isCancelAllTasks() {
        return this.cancelAllTasks;
    }

    public void setCancelAllTasks(boolean bl) {
        this.cancelAllTasks = bl;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean bl) {
        this.pause = bl;
    }

    public static final class Task
    extends Enum<Task> {
        public static final /* enum */ Task NONE;
        public static final /* enum */ Task ADD_ENTRY;
        public static final /* enum */ Task REMOVE_ENTRY;
        public static final /* enum */ Task CALCULATE_CRC;
        public static final /* enum */ Task EXTRACT_ENTRY;
        public static final /* enum */ Task MERGE_ZIP_FILES;
        public static final /* enum */ Task SET_COMMENT;
        public static final /* enum */ Task RENAME_FILE;
        private static final /* synthetic */ Task[] $VALUES;

        public static Task[] values() {
            return (Task[])$VALUES.clone();
        }

        public static Task valueOf(String string2) {
            return Enum.valueOf(Task.class, string2);
        }

        static {
            Task task;
            Task task2;
            Task task3;
            Task task4;
            Task task5;
            Task task6;
            Task task7;
            Task task8;
            Task task9 = task8;
            NONE = new Task();
            Task task10 = task7;
            ADD_ENTRY = new Task();
            Task task11 = task6;
            REMOVE_ENTRY = new Task();
            Task task12 = task5;
            CALCULATE_CRC = new Task();
            Task task13 = task4;
            EXTRACT_ENTRY = new Task();
            Task task14 = task3;
            MERGE_ZIP_FILES = new Task();
            Task task15 = task2;
            SET_COMMENT = new Task();
            Task task16 = task;
            RENAME_FILE = new Task();
            $VALUES = new Task[]{task9, task10, task11, task12, task13, task14, task15, task16};
        }
    }

    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result SUCCESS;
        public static final /* enum */ Result WORK_IN_PROGRESS;
        public static final /* enum */ Result ERROR;
        public static final /* enum */ Result CANCELLED;
        private static final /* synthetic */ Result[] $VALUES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String string2) {
            return Enum.valueOf(Result.class, string2);
        }

        static {
            Result result;
            Result result2;
            Result result3;
            Result result4;
            Result result5 = result4;
            SUCCESS = new Result();
            Result result6 = result3;
            WORK_IN_PROGRESS = new Result();
            Result result7 = result2;
            ERROR = new Result();
            Result result8 = result;
            CANCELLED = new Result();
            $VALUES = new Result[]{result5, result6, result7, result8};
        }
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State READY;
        public static final /* enum */ State BUSY;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        static {
            State state;
            State state2;
            State state3 = state2;
            READY = new State();
            State state4 = state;
            BUSY = new State();
            $VALUES = new State[]{state3, state4};
        }
    }
}

