/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code93Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public class Code93Writer
extends OneDimensionalCodeWriter {
    private static void toIntArray(int n2, int[] nArray) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n3 = (n2 & 1 << 8 - i2) == 0 ? 0 : 1;
            nArray[i2] = n3;
        }
    }

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean n3) {
        n3 = nArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = n2 + 1;
            boolean bl = nArray[i2] != 0;
            blArray[n2] = bl;
            n2 = n4;
        }
        return 9;
    }

    private static int computeChecksumIndex(String string2, int n2) {
        int n3 = 1;
        int n4 = 0;
        for (int i2 = string2.length() - 1; i2 >= 0; --i2) {
            n4 += "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string2.charAt(i2)) * n3;
            if (++n3 <= n2) continue;
            n3 = 1;
        }
        return n4 % 47;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_93) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_93, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n2 = string2.length();
        if (n2 <= 80) {
            int[] nArray = new int[9];
            boolean[] blArray = new boolean[(string2.length() + 2 + 2) * 9 + 1];
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[47], nArray);
            int n3 = Code93Writer.appendPattern(blArray, 0, nArray, true);
            for (int i2 = 0; i2 < n2; ++i2) {
                Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS["0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(string2.charAt(i2))], nArray);
                n3 += Code93Writer.appendPattern(blArray, n3, nArray, true);
            }
            n2 = Code93Writer.computeChecksumIndex(string2, 20);
            int[] nArray2 = Code93Reader.CHARACTER_ENCODINGS;
            Code93Writer.toIntArray(Code93Reader.CHARACTER_ENCODINGS[n2], nArray);
            int n4 = n3 + Code93Writer.appendPattern(blArray, n3, nArray, true);
            Code93Writer.toIntArray(nArray2[Code93Writer.computeChecksumIndex(string2 + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(n2), 15)], nArray);
            int n5 = n4 + Code93Writer.appendPattern(blArray, n4, nArray, true);
            Code93Writer.toIntArray(nArray2[47], nArray);
            blArray[n5 + Code93Writer.appendPattern((boolean[])blArray, (int)n5, (int[])nArray, (boolean)true)] = true;
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
    }
}

