/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.widget.ImageView;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.core.imageaware.ImageViewAware;
import com.nostra13.dcloudimageloader.utils.L;

public class RoundedBitmapDisplayer
implements BitmapDisplayer {
    private final int roundPixels;

    public RoundedBitmapDisplayer(int n2) {
        this.roundPixels = n2;
    }

    public static Bitmap roundCorners(Bitmap bitmap, ImageViewAware imageViewAware, int n2) {
        Rect rect;
        Rect rect2;
        ImageView imageView = imageViewAware.getWrappedView();
        if (imageView == null) {
            L.w("View is collected probably. Can't round bitmap corners without view properties.", new Object[0]);
            return bitmap;
        }
        Bitmap bitmap2 = bitmap;
        int n3 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        int n5 = imageViewAware.getWidth();
        int n6 = imageViewAware.getHeight();
        if (n5 <= 0) {
            n5 = n3;
        }
        if (n6 <= 0) {
            n6 = n4;
        }
        if ((imageView = imageView.getScaleType()) == null) {
            return bitmap;
        }
        int n7 = imageView.ordinal();
        if (n7 != 1) {
            switch (n7) {
                default: {
                    Rect rect3;
                    Rect rect4;
                    float f2;
                    float f3;
                    float f4;
                    float f5;
                    float f6 = n5;
                    float f7 = n6;
                    float f8 = n3;
                    float f9 = n4;
                    if (f5 / f4 > f3 / f2) {
                        n5 = (int)(f8 / (f9 / f7));
                    } else {
                        n6 = (int)(f9 / (f8 / f6));
                    }
                    Rect rect5 = rect4;
                    rect4 = new Rect(0, 0, n3, n4);
                    rect2 = rect3;
                    rect3 = new Rect(0, 0, n5, n6);
                    n4 = n6;
                    n6 = n5;
                    rect = rect5;
                    break;
                }
                case 7: 
                case 8: {
                    Rect rect6;
                    Rect rect7;
                    n5 = Math.min(n5, n3);
                    n6 = Math.min(n6, n4);
                    n7 = (n3 - n5) / 2;
                    n3 = (n4 - n6) / 2;
                    Rect rect8 = rect7;
                    int n8 = n3 + n6;
                    rect7 = new Rect(n7, n3, n7 += n5, n8);
                    rect2 = rect6;
                    rect6 = new Rect(0, 0, n5, n6);
                    n4 = n6;
                    n6 = n5;
                    rect = rect8;
                    break;
                }
                case 6: {
                    Rect rect9;
                    Rect rect10;
                    Rect rect11 = rect10;
                    rect10 = new Rect(0, 0, n3, n4);
                    rect2 = rect9;
                    rect9 = new Rect(0, 0, n5, n6);
                    n4 = n6;
                    n6 = n5;
                    rect = rect11;
                    break;
                }
                case 5: {
                    Rect rect12;
                    Rect rect13;
                    int n9;
                    int n10;
                    float f10;
                    float f11;
                    float f12;
                    float f13;
                    float f14 = n5;
                    float f15 = n6;
                    float f16 = n3;
                    float f17 = n4;
                    if (f13 / f12 > f11 / f10) {
                        int n11 = n4;
                        n4 = (int)(f15 * (f16 / f14));
                        n10 = 0;
                        n9 = (n11 - n4) / 2;
                    } else {
                        int n12 = n3;
                        n3 = (int)(f14 * (f17 / f15));
                        n10 = (n12 - n3) / 2;
                        n9 = 0;
                    }
                    Rect rect14 = rect13;
                    int n13 = n10 + n3;
                    int n14 = n9 + n4;
                    rect13 = new Rect(n10, n9, n13, n14);
                    Rect rect15 = rect12;
                    rect12 = new Rect(0, 0, n3, n4);
                    n6 = n3;
                    rect2 = rect15;
                    rect = rect14;
                    break;
                }
            }
        } else {
            Rect rect16;
            Rect rect17;
            int n15;
            int n16;
            float f18;
            float f19;
            float f20 = n3;
            float f21 = n4;
            if ((float)n5 / (float)n6 > f19 / f18) {
                n16 = Math.min(n6, n4);
                n15 = (int)(f20 / (f21 / (float)n16));
            } else {
                n15 = Math.min(n5, n3);
                n16 = (int)(f21 / (f20 / (float)n15));
            }
            int n17 = (n5 - n15) / 2;
            int n18 = (n6 - n16) / 2;
            rect = rect17;
            rect17 = new Rect(0, 0, n3, n4);
            rect2 = rect16;
            int n19 = n16;
            n16 = n17 + n15;
            n4 = n18 + n19;
            rect16 = new Rect(n17, n18, n16, n4);
            n4 = n6;
            n6 = n5;
        }
        try {
            bitmap = RoundedBitmapDisplayer.getRoundedCornerBitmap(bitmap, n2, rect, rect2, n6, n4);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            L.e(outOfMemoryError, "Can't create bitmap with rounded corners. Not enough memory.", new Object[0]);
        }
        return bitmap;
    }

    private static Bitmap getRoundedCornerBitmap(Bitmap bitmap, int n2, Rect rect, Rect rect2, int n3, int n4) {
        RectF rectF;
        Paint paint;
        Canvas canvas;
        Bitmap bitmap2 = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        Bitmap bitmap3 = bitmap;
        canvas2(bitmap2);
        Bitmap bitmap4 = bitmap = paint;
        bitmap4();
        RectF rectF2 = rectF;
        rectF = new RectF(rect2);
        bitmap4.setAntiAlias(true);
        canvas2.drawARGB(0, 0, 0, 0);
        bitmap.setColor(-16777216);
        float f2 = n2;
        canvas2.drawRoundRect(rectF2, f2, f2, (Paint)bitmap);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap3, rect, rectF2, (Paint)bitmap);
        return bitmap2;
    }

    @Override
    public Bitmap display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        if (imageAware instanceof ImageViewAware) {
            RoundedBitmapDisplayer roundedBitmapDisplayer = imageViewAware;
            ImageViewAware imageViewAware = (ImageViewAware)imageAware;
            Bitmap bitmap2 = RoundedBitmapDisplayer.roundCorners(bitmap, imageViewAware, roundedBitmapDisplayer.roundPixels);
            imageAware.setImageBitmap(bitmap2);
            return bitmap2;
        }
        throw new IllegalArgumentException("ImageAware should wrap ImageView. ImageViewAware is expected.");
    }
}

