/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.utils;

import android.content.Context;
import android.os.Environment;
import com.nostra13.dcloudimageloader.utils.L;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "uil-images";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        Object object2 = null;
        if (bl && "mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(object)) {
            object2 = StorageUtils.getExternalCacheDir(object);
        }
        if (object2 == null) {
            object2 = object.getCacheDir();
        }
        if (object2 == null) {
            File file;
            object = "/data/data/" + object.getPackageName() + "/cache/";
            Object[] objectArray = new Object[1];
            object2 = objectArray;
            objectArray[0] = object;
            L.w("Can't define system cache directory! '%s' will be used.", object2);
            object2 = file;
            file = new File((String)object);
        }
        return object2;
    }

    public static File getIndividualCacheDirectory(Context object) {
        File file;
        object = StorageUtils.getCacheDirectory(object);
        File file2 = file;
        if (!new File((File)object, INDIVIDUAL_DIR_NAME).exists() && !file2.mkdir()) {
            file2 = object;
        }
        return file2;
    }

    public static File getOwnCacheDirectory(Context context, String string2) {
        File file = null;
        if ("mounted".equals(Environment.getExternalStorageState()) && StorageUtils.hasExternalStoragePermission(context)) {
            File file2;
            file = file2;
            file2 = new File(Environment.getExternalStorageDirectory(), string2);
        }
        if (file == null || !file.exists() && !file.mkdirs()) {
            file = context.getCacheDir();
        }
        return file;
    }

    private static File getExternalCacheDir(Context context) {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file4 = file;
        if (!new File(new File(file3, context.getPackageName()), "cache").exists()) {
            if (!file4.mkdirs()) {
                L.w("Unable to create external cache directory", new Object[0]);
                return null;
            }
            try {
                new File(file4, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                L.i("Can't create \".nomedia\" file in application external cache directory", new Object[0]);
            }
        }
        return file4;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }
}

