/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CipherSuite;
import dc.squareup.okhttp3.TlsVersion;
import dc.squareup.okhttp3.internal.Util;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpec {
    private static final CipherSuite[] RESTRICTED_CIPHER_SUITES;
    private static final CipherSuite[] APPROVED_CIPHER_SUITES;
    public static final ConnectionSpec RESTRICTED_TLS;
    public static final ConnectionSpec MODERN_TLS;
    public static final ConnectionSpec COMPATIBLE_TLS;
    public static final ConnectionSpec CLEARTEXT;
    final boolean tls;
    final boolean supportsTlsExtensions;
    @Nullable
    final String[] cipherSuites;
    @Nullable
    final String[] tlsVersions;

    ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    private ConnectionSpec supportedSpec(SSLSocket stringArray, boolean n2) {
        String[] stringArray2;
        String[] stringArray3;
        if (this.cipherSuites != null) {
            stringArray3 = stringArray.getEnabledCipherSuites();
            stringArray3 = Util.intersect(CipherSuite.ORDER_BY_NAME, stringArray3, this.cipherSuites);
        } else {
            stringArray3 = stringArray.getEnabledCipherSuites();
        }
        if (this.tlsVersions != null) {
            stringArray2 = stringArray.getEnabledProtocols();
            stringArray2 = Util.intersect(Util.NATURAL_ORDER, stringArray2, this.tlsVersions);
        } else {
            stringArray2 = stringArray.getEnabledProtocols();
        }
        int n3 = n2;
        stringArray = stringArray.getSupportedCipherSuites();
        n2 = Util.indexOf(CipherSuite.ORDER_BY_NAME, stringArray, "TLS_FALLBACK_SCSV");
        if (n3 != 0 && n2 != -1) {
            stringArray3 = Util.concat(stringArray3, stringArray[n2]);
        }
        return new Builder(this).cipherSuites(stringArray3).tlsVersions(stringArray2).build();
    }

    static {
        CipherSuite cipherSuite;
        CipherSuite cipherSuite2;
        CipherSuite cipherSuite3;
        CipherSuite cipherSuite4;
        CipherSuite cipherSuite5;
        CipherSuite cipherSuite6;
        CipherSuite cipherSuite7;
        CipherSuite cipherSuite8;
        CipherSuite cipherSuite9;
        CipherSuite cipherSuite10;
        Object object;
        CipherSuite[] cipherSuiteArray = new CipherSuite[11];
        Object object2 = cipherSuiteArray;
        cipherSuiteArray[0] = object = CipherSuite.TLS_AES_128_GCM_SHA256;
        cipherSuiteArray[1] = cipherSuite10 = CipherSuite.TLS_AES_256_GCM_SHA384;
        cipherSuiteArray[2] = cipherSuite9 = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[3] = cipherSuite8 = CipherSuite.TLS_AES_128_CCM_SHA256;
        cipherSuiteArray[4] = cipherSuite7 = CipherSuite.TLS_AES_256_CCM_8_SHA256;
        cipherSuiteArray[5] = cipherSuite6 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[6] = cipherSuite5 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray[7] = cipherSuite4 = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[8] = cipherSuite3 = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray[9] = cipherSuite2 = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        cipherSuiteArray[10] = cipherSuite = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        RESTRICTED_CIPHER_SUITES = cipherSuiteArray;
        CipherSuite[] cipherSuiteArray2 = new CipherSuite[18];
        CipherSuite[] cipherSuiteArray3 = cipherSuiteArray2;
        cipherSuiteArray2[0] = object;
        cipherSuiteArray2[1] = cipherSuite10;
        cipherSuiteArray2[2] = cipherSuite9;
        cipherSuiteArray2[3] = cipherSuite8;
        cipherSuiteArray2[4] = cipherSuite7;
        cipherSuiteArray2[5] = cipherSuite6;
        cipherSuiteArray2[6] = cipherSuite5;
        cipherSuiteArray2[7] = cipherSuite4;
        cipherSuiteArray2[8] = cipherSuite3;
        cipherSuiteArray2[9] = cipherSuite2;
        cipherSuiteArray2[10] = cipherSuite;
        cipherSuiteArray2[11] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[12] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[13] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        cipherSuiteArray2[14] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        cipherSuiteArray2[15] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        cipherSuiteArray2[16] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        cipherSuiteArray2[17] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = cipherSuiteArray2;
        Builder builder = new Builder(true).cipherSuites((CipherSuite)object2);
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        tlsVersionArray[0] = object2 = TlsVersion.TLS_1_3;
        object = TlsVersion.TLS_1_2;
        tlsVersionArray[1] = object;
        RESTRICTED_TLS = builder.tlsVersions(tlsVersionArray).supportsTlsExtensions(true).build();
        MODERN_TLS = new Builder(true).cipherSuites(cipherSuiteArray3).tlsVersions(new TlsVersion[]{object2, object, TlsVersion.TLS_1_1, object2 = TlsVersion.TLS_1_0}).supportsTlsExtensions(true).build();
        COMPATIBLE_TLS = new Builder(true).cipherSuites(cipherSuiteArray3).tlsVersions(new TlsVersion[]{object2}).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    public boolean isTls() {
        return this.tls;
    }

    @Nullable
    public List<CipherSuite> cipherSuites() {
        String[] stringArray = stringArray.cipherSuites;
        return stringArray.cipherSuites != null ? CipherSuite.forJavaNames(stringArray) : null;
    }

    @Nullable
    public List<TlsVersion> tlsVersions() {
        String[] stringArray = stringArray.tlsVersions;
        return stringArray.tlsVersions != null ? TlsVersion.forJavaNames(stringArray) : null;
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    void apply(SSLSocket sSLSocket, boolean bl) {
        String[] stringArray = stringArray.supportedSpec(sSLSocket, bl);
        String[] stringArray2 = stringArray.tlsVersions;
        if (stringArray.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(stringArray2);
        }
        stringArray = stringArray.cipherSuites;
        if (stringArray.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
    }

    public boolean isCompatible(SSLSocket sSLSocket) {
        if (!stringArray2.tls) {
            return false;
        }
        String[] stringArray = stringArray2.tlsVersions;
        if (stringArray2.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, stringArray, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        String[] stringArray2 = stringArray2.cipherSuites;
        return stringArray2.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.ORDER_BY_NAME, stringArray2, sSLSocket.getEnabledCipherSuites());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        object = (ConnectionSpec)object;
        boolean bl = this.tls;
        if (bl != ((ConnectionSpec)object).tls) {
            return false;
        }
        if (bl) {
            if (!Arrays.equals(this.cipherSuites, ((ConnectionSpec)object).cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, ((ConnectionSpec)object).tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)object).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 17;
        if (this.tls) {
            n2 = ((527 + Arrays.hashCode(this.cipherSuites)) * 31 + Arrays.hashCode(this.tlsVersions)) * 31 + (this.supportsTlsExtensions ^ 1);
        }
        return n2;
    }

    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string2 = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string3 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string2 + ", tlsVersions=" + string3 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    public static final class Builder {
        boolean tls;
        @Nullable
        String[] cipherSuites;
        @Nullable
        String[] tlsVersions;
        boolean supportsTlsExtensions;

        Builder(boolean bl) {
            this.tls = bl;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        public Builder allEnabledCipherSuites() {
            if (this.tls) {
                this.cipherSuites = null;
                return this;
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (this.tls) {
                String[] stringArray = new String[cipherSuiteArray.length];
                for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
                    stringArray[i2] = cipherSuiteArray[i2].javaName;
                }
                return this.cipherSuites(stringArray);
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder cipherSuites(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.cipherSuites = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            throw new IllegalStateException("no cipher suites for cleartext connections");
        }

        public Builder allEnabledTlsVersions() {
            if (this.tls) {
                this.tlsVersions = null;
                return this;
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (this.tls) {
                String[] stringArray = new String[tlsVersionArray.length];
                for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
                    stringArray[i2] = tlsVersionArray[i2].javaName;
                }
                return this.tlsVersions(stringArray);
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder tlsVersions(String ... stringArray) {
            if (this.tls) {
                if (stringArray.length != 0) {
                    this.tlsVersions = (String[])stringArray.clone();
                    return this;
                }
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            throw new IllegalStateException("no TLS versions for cleartext connections");
        }

        public Builder supportsTlsExtensions(boolean bl) {
            if (this.tls) {
                this.supportsTlsExtensions = bl;
                return this;
            }
            throw new IllegalStateException("no TLS extensions for cleartext connections");
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }
    }
}

