/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Address;
import java.net.InetSocketAddress;
import java.net.Proxy;

public final class Route {
    final Address address;
    final Proxy proxy;
    final InetSocketAddress inetSocketAddress;

    public Route(Address address, Proxy proxy, InetSocketAddress inetSocketAddress) {
        if (address != null) {
            if (proxy != null) {
                if (inetSocketAddress != null) {
                    Route route = this;
                    route.address = address;
                    route.proxy = proxy;
                    route.inetSocketAddress = inetSocketAddress;
                    return;
                }
                throw new NullPointerException("inetSocketAddress == null");
            }
            throw new NullPointerException("proxy == null");
        }
        throw new NullPointerException("address == null");
    }

    public Address address() {
        return this.address;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public InetSocketAddress socketAddress() {
        return this.inetSocketAddress;
    }

    public boolean requiresTunnel() {
        return this.address.sslSocketFactory != null && this.proxy.type() == Proxy.Type.HTTP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Route)) return false;
        object = (Route)object;
        if (!((Route)object).address.equals(this.address)) return false;
        if (!((Route)object).proxy.equals(this.proxy)) return false;
        if (!((Route)object).inetSocketAddress.equals(this.inetSocketAddress)) return false;
        return true;
    }

    public int hashCode() {
        return ((527 + this.address.hashCode()) * 31 + this.proxy.hashCode()) * 31 + this.inetSocketAddress.hashCode();
    }

    public String toString() {
        return "Route{" + this.inetSocketAddress + "}";
    }
}

