/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.util.zip.Deflater;
import net.lingala.zip4j.io.outputstream.CipherOutputStream;
import net.lingala.zip4j.io.outputstream.CompressedOutputStream;
import net.lingala.zip4j.model.enums.CompressionLevel;

class DeflaterOutputStream
extends CompressedOutputStream {
    private byte[] buff;
    protected Deflater deflater;

    public DeflaterOutputStream(CipherOutputStream<?> cipherOutputStream, CompressionLevel compressionLevel, int n2) {
        super(cipherOutputStream);
        this.deflater = new Deflater(compressionLevel.getLevel(), true);
        this.buff = new byte[n2];
    }

    private void deflate() throws IOException {
        int n2 = this.deflater.deflate(this.buff, 0, this.buff.length);
        if (n2 > 0) {
            DeflaterOutputStream deflaterOutputStream = this;
            super.write(deflaterOutputStream.buff, 0, n2);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(int n2) throws IOException {
        DeflaterOutputStream deflaterOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        deflaterOutputStream.write((byte[])object, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.deflater.setInput(byArray, n2, n3);
        while (!this.deflater.needsInput()) {
            this.deflate();
        }
    }

    @Override
    public void closeEntry() throws IOException {
        if (!this.deflater.finished()) {
            this.deflater.finish();
            while (!this.deflater.finished()) {
                this.deflate();
            }
        }
        DeflaterOutputStream deflaterOutputStream = this;
        deflaterOutputStream.deflater.end();
        super.closeEntry();
    }
}

