/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

public class SingleByteCharsetProber
extends CharsetProber {
    public static final int SAMPLE_SIZE = 64;
    public static final int SB_ENOUGH_REL_THRESHOLD = 1024;
    public static final float POSITIVE_SHORTCUT_THRESHOLD = 0.95f;
    public static final float NEGATIVE_SHORTCUT_THRESHOLD = 0.05f;
    public static final int SYMBOL_CAT_ORDER = 250;
    public static final int NUMBER_OF_SEQ_CAT = 4;
    public static final int POSITIVE_CAT = 3;
    public static final int NEGATIVE_CAT = 0;
    private CharsetProber.ProbingState state;
    private SequenceModel model;
    private boolean reversed;
    private short lastOrder;
    private int totalSeqs;
    private int[] seqCounters;
    private int totalChar;
    private int freqChar;
    private CharsetProber nameProber;

    public SingleByteCharsetProber(SequenceModel sequenceModel) {
        this.model = sequenceModel;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    public SingleByteCharsetProber(SequenceModel sequenceModel, boolean bl, CharsetProber charsetProber) {
        this.model = sequenceModel;
        this.reversed = bl;
        this.nameProber = charsetProber;
        this.seqCounters = new int[4];
        this.reset();
    }

    boolean keepEnglishLetters() {
        return this.model.getKeepEnglishLetter();
    }

    @Override
    public String getCharSetName() {
        CharsetProber charsetProber = this.nameProber;
        if (charsetProber == null) {
            return this.model.getCharsetName();
        }
        return charsetProber.getCharSetName();
    }

    @Override
    public float getConfidence() {
        int n2 = this.totalSeqs;
        if (n2 > 0) {
            float f2;
            float f3 = (float)this.seqCounters[3] * 1.0f / (float)n2 / this.model.getTypicalPositiveRatio() * (float)this.freqChar / (float)this.totalChar;
            if (f2 >= 1.0f) {
                f3 = 0.99f;
            }
            return f3;
        }
        return 0.01f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        while (n2 < n3) {
            short s = this.model.getOrder(byArray[n2]);
            if (s < 250) {
                ++this.totalChar;
            }
            if (s < 64) {
                SingleByteCharsetProber singleByteCharsetProber = this;
                ++singleByteCharsetProber.freqChar;
                short s2 = singleByteCharsetProber.lastOrder;
                if (s2 < 64) {
                    SingleByteCharsetProber singleByteCharsetProber2 = this;
                    ++singleByteCharsetProber2.totalSeqs;
                    if (!singleByteCharsetProber2.reversed) {
                        byte by = this.model.getPrecedence(s2 * 64 + s);
                        s2 = by;
                        this.seqCounters[s2] = this.seqCounters[by] + 1;
                    } else {
                        byte by = this.model.getPrecedence(s * 64 + s2);
                        s2 = by;
                        this.seqCounters[s2] = this.seqCounters[by] + 1;
                    }
                }
            }
            this.lastOrder = s;
            ++n2;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.totalSeqs > 1024) {
            float f2;
            float f3 = this.getConfidence();
            if (f2 > 0.95f) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
            } else if (f3 < 0.05f) {
                this.state = CharsetProber.ProbingState.NOT_ME;
            }
        }
        return this.state;
    }

    @Override
    public void reset() {
        SingleByteCharsetProber singleByteCharsetProber = this;
        singleByteCharsetProber.state = CharsetProber.ProbingState.DETECTING;
        singleByteCharsetProber.lastOrder = (short)255;
        for (int i2 = 0; i2 < 4; ++i2) {
            this.seqCounters[i2] = 0;
        }
        SingleByteCharsetProber singleByteCharsetProber2 = this;
        singleByteCharsetProber2.totalSeqs = 0;
        singleByteCharsetProber2.totalChar = 0;
        singleByteCharsetProber2.freqChar = 0;
    }

    @Override
    public void setOption() {
    }
}

